/*
	skyeye_lcd.c - skyeye general lcd device file support functions
	Copyright (C) 2003 - 2005 Skyeye Develop Group
        for help please send mail to <skyeye-developer@lists.gro.clinux.org>
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
*/

/*
 * 06/22/2005 	initial version
 *			walimis <wlm@student.dlut.edu.cn>
 */

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
//koodailar add for mingw 2005.12.18 ----------------------------------------
#ifdef __MINGW32__
#include "arch/arm/common/armdefs.h"
#include "device/skyeye_device.h"
#else
#include "armdefs.h"
#include "skyeye_device.h"
#endif
// end ----------------------------------------------------------------------
#include "skyeye_options.h"
#include "skyeye.h"
#include "skyeye_lcd.h"


/* initialize the lcd module set.
 * If you want to add a new lcd simulation, just add a "lcd_*_init" function to it.
 * */
static void
lcd_init (struct device_module_set *mod_set)
{
	lcd_ep7312_init (mod_set);
	lcd_pxa_init (mod_set);
	lcd_s3c2410_init (mod_set);
}
static int
lcd_setup (struct device_desc *dev, void *option)
{
	struct lcd_device *lcd_dev;
	struct lcd_option *lcd_opt = (struct lcd_option *) option;
	int ret = 0;

	lcd_dev = (struct lcd_device *) malloc (sizeof (struct lcd_device));
	if (lcd_dev == NULL)
		return 1;

	memset (lcd_dev, 0, sizeof (lcd_dev));

	lcd_dev->mod = lcd_opt->mod;
	printf ("lcd_mod:%d\n", lcd_dev->mod);
	switch (lcd_dev->mod) {
	case LCD_MOD_GTK:
		lcd_dev->lcd_open = gtk_lcd_open;
		lcd_dev->lcd_close = gtk_lcd_close;
		lcd_dev->lcd_update = gtk_lcd_update;
		lcd_dev->lcd_read = gtk_lcd_read;
		lcd_dev->lcd_write = gtk_lcd_write;
		break;
	case LCD_MOD_QT:
	case LCD_MOD_X:
	case LCD_MOD_SDL:
		break;
	}

	dev->dev = (void *) lcd_dev;
	return ret;

}
static struct device_module_set lcd_mod_set = {
	.name = "lcd",
	.count = 0,
	.count_max = 0,
	.init = lcd_init,
	.initialized = 0,
	.setup_module = lcd_setup,
};

/* used by global device initialize function. 
 * */
void
lcd_register ()
{
	if (register_device_module_set (&lcd_mod_set))
		SKYEYE_ERR ("\"%s\" module set register error!\n",
			    lcd_mod_set.name);
}

/* help functions. */
