/****************************************************************/
/* Threads unit                                                 */
/* (c) Christophe CALMEJANE (Ze KiLleR) - 1999-03               */
/****************************************************************/

/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "skyutils.h"

#ifndef SU_TRACE_INTERNAL
#undef malloc
#undef calloc
#undef realloc
#undef strdup
#undef free
#endif /* !SU_TRACE_INTERNAL */

bool SU_CreateThread(SU_THREAD_HANDLE *Handle,SU_THREAD_ROUTINE_TYPE(Entry),void *User,bool Detached)
{
#ifdef _WIN32
  *Handle = _beginthread(Entry,0,User);
  return ((*Handle) != -1);
#else /* !_WIN32 */
  if(pthread_create(Handle,NULL,Entry,User) != 0)
    return false;
  if(Detached)
    pthread_detach(*Handle);
  return true;
#endif /* _WIN32 */
}

void SU_KillThread(SU_THREAD_HANDLE Handle)
{
#ifdef _WIN32
  TerminateThread((void *)Handle,0);
#else /* !_WIN32 */
  pthread_kill(Handle,SIGKILL);
#endif /* _WIN32 */
}

void SU_TermThread(SU_THREAD_HANDLE Handle)
{
#ifdef _WIN32
  TerminateThread((void *)Handle,0);
#else /* !_WIN32 */
  pthread_kill(Handle,SIGTERM);
#endif /* _WIN32 */
}

void SU_SuspendThread(SU_THREAD_HANDLE Handle)
{
#ifdef _WIN32
  SuspendThread((void *)Handle);
#else /* !_WIN32 */
  pthread_kill(Handle,SIGSTOP);
#endif /* _WIN32 */
}

void SU_ResumeThread(SU_THREAD_HANDLE Handle)
{
#ifdef _WIN32
  ResumeThread((void *)Handle);
#else /* !_WIN32 */
  pthread_kill(Handle,SIGCONT);
#endif /* _WIN32 */
}

bool SU_CreateThreadKey(SU_THREAD_KEY_HANDLE *Handle,SU_THREAD_ONCE_HANDLE *Once,void (*destroyts)(void *))
{
#ifdef _WIN32
  if(*Once == SU_THREAD_ONCE_INIT)
  {
    *Handle = TlsAlloc();
    (*Once)++;
  }
  return ((*Handle) != 0xFFFFFFFF);
#else /* !_WIN32 */
  return  pthread_key_create(Handle,destroyts) == 0;
#endif /* _WIN32 */
}

bool SU_CreateSem(SU_SEM_HANDLE *Handle,int InitialCount,int MaximumCount,const char SemName[])
{
#ifdef _WIN32
  *Handle = CreateSemaphore(NULL,InitialCount,MaximumCount,SemName);
  return ((*Handle) != NULL);
#else /* !_WIN32 */
  return sem_init(Handle,0,InitialCount) == 0;
#endif /* _WIN32 */
}

bool SU_FreeSem(SU_SEM_HANDLE *Handle)
{
#ifdef _WIN32
  return CloseHandle(*Handle);
#else /* !_WIN32 */
  return sem_destroy(Handle) == 0;
#endif /* _WIN32 */
}

void SU_ThreadBlockSigs(void)
{
#ifdef __unix__
  sigset_t mask;

  sigfillset(&mask);
  pthread_sigmask(SIG_BLOCK,&mask,NULL);
#endif /* __unix__ */
}
