# Copyright 2001 Free Software Foundation, Inc.             -*- Autoconf -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

dnl A good portion of the content of this script originated from the
dnl distributions of either S-Lang (http://www.s-lang.org) or some
dnl of the early S-Lang modules.
dnl -*- sh -*-

AC_DEFUN(AX_PATH_SET, dnl {{{
[
   AX_PATH_PROG_PATH=$PATH:/bin:/usr/bin:/usr/local/bin:/opt/local/bin:/sw/bin
])dnl }}}

AC_DEFUN(AX_PATH_PROG, dnl {{{
[
   AC_REQUIRE([AX_PATH_SET])
   AC_PATH_PROG([$1],[$2],[$3],[$AX_PATH_PROG_PATH:$4])
])dnl }}}

AC_DEFUN(JD_SLANG_VERSION, dnl#{{{
[
 slang_h=$jd_slang_include_dir/slang.h
 AC_MSG_CHECKING(SLANG_VERSION in $slang_h)
slang_version=`grep "^#define  *SLANG_VERSION " $slang_h |
               awk '{ print [$]3 }'`
slang_major_version=`echo $slang_version |
 awk '{ print int([$]1/10000) }'`
slang_minor_version=`echo $slang_version $slang_major_version |
 awk '{ print int(([$]1 - [$]2*10000)/100) }'`
slang_patchlevel_version=`echo $slang_version $slang_major_version $slang_minor_version |
 awk '{ print ([$]1 - [$]2*10000 - [$]3*100) }'`

AC_MSG_RESULT($slang_major_version.$slang_minor_version.$slang_patchlevel_version)
AC_SUBST(slang_version)
AC_SUBST(slang_major_version)
AC_SUBST(slang_minor_version)
AC_SUBST(slang_patchlevel_version)
])
#}}}

AC_DEFUN(JD_SLANG_MODULE_INSTALL_DIR, dnl#{{{
[
  AC_REQUIRE([JD_SLANG_VERSION])
  if test "X$slang_major_version" = "X1"
  then
    MODULE_INSTALL_DIR="$libdir/slang/modules"
  else
    MODULE_INSTALL_DIR="$libdir/slang/v$slang_major_version/modules"
  fi
  SL_FILES_INSTALL_DIR=$datadir/slsh/local-packages
  AC_SUBST(MODULE_INSTALL_DIR)
  AC_SUBST(SL_FILES_INSTALL_DIR)
])
#}}}

dnl# This function expand the "prefix variables.  For example, it will expand
dnl# values such as ${exec_prefix}/foo when ${exec_prefix} itself has a 
dnl# of ${prefix}.  This function produces the shell variables:
dnl# jd_prefix_libdir, jd_prefix_incdir
AC_DEFUN(JD_EXPAND_PREFIX, dnl#{{{
[
  if test "X$jd_prefix" = "X"
  then
    jd_prefix=$ac_default_prefix
    if test "X$prefix" != "XNONE"
    then
      jd_prefix="$prefix"
    fi
    jd_exec_prefix="$jd_prefix"
    if test "X$exec_prefix" != "XNONE"
    then
      jd_exec_prefix="$exec_prefix"
    fi
  
    dnl#Unfortunately, exec_prefix may have a value like ${prefix}, etc.
    dnl#Let the shell expand those.  Yuk.
    eval `sh <<EOF
      prefix=$jd_prefix
      exec_prefix=$jd_exec_prefix
      libdir=$libdir
      includedir=$includedir
      echo jd_prefix_libdir="\$libdir" jd_prefix_incdir="\$includedir"
EOF
`
  fi
])
#}}}

AC_DEFUN([AX_OPENMP], [ 	dnl {{{
dnl OpenMP macro Copyright 2006 Steven G. Johnson (stevenj@alum.mit.edu)
AC_PREREQ(2.59) dnl for _AC_LANG_PREFIX

AC_CACHE_CHECK([for OpenMP flag of _AC_LANG compiler], ax_cv_[]_AC_LANG_ABBREV[]_openmp, [save[]_AC_LANG_PREFIX[]FLAGS=$[]_AC_LANG_PREFIX[]FLAGS
ax_cv_[]_AC_LANG_ABBREV[]_openmp=unknown
# Flags to try:  -fopenmp (gcc), -openmp (icc), -mp (SGI &amp; PGI),
#                -xopenmp (Sun), -omp (Tru64), -qsmp=omp (AIX), none
ax_openmp_flags="-fopenmp -openmp -mp -xopenmp -omp -qsmp=omp none"
if test "x$OPENMP_[]_AC_LANG_PREFIX[]FLAGS" != x; then
  ax_openmp_flags="$OPENMP_[]_AC_LANG_PREFIX[]FLAGS $ax_openmp_flags"
fi
for ax_openmp_flag in $ax_openmp_flags; do
  case $ax_openmp_flag in
    none) []_AC_LANG_PREFIX[]FLAGS=$save[]_AC_LANG_PREFIX[] ;;
    *) []_AC_LANG_PREFIX[]FLAGS="$save[]_AC_LANG_PREFIX[]FLAGS $ax_openmp_flag" ;;
  esac
  AC_TRY_LINK_FUNC(omp_set_num_threads,
        [ax_cv_[]_AC_LANG_ABBREV[]_openmp=$ax_openmp_flag; break])
done
[]_AC_LANG_PREFIX[]FLAGS=$save[]_AC_LANG_PREFIX[]FLAGS
])
if test "x$ax_cv_[]_AC_LANG_ABBREV[]_openmp" = "xunknown"; then
  m4_default([$2],:)
else
  if test "x$ax_cv_[]_AC_LANG_ABBREV[]_openmp" != "xnone"; then
    OPENMP_[]_AC_LANG_PREFIX[]FLAGS=$ax_cv_[]_AC_LANG_ABBREV[]_openmp
  fi
  m4_default([$1], [AC_DEFINE(HAVE_OPENMP,1,[Define if OpenMP is enabled])])
fi
])dnl AX_OPENMP }}}

AC_DEFUN(AC_FIND_SLANG, dnl {{{
[

JD_WITH_LIBRARY(slang)

JD_SLANG_VERSION

echo "SLang version is $slang_version"
required_slang_version_as_int=`echo $1 | tr '.' '0'`
if test -z "$slang_version" || test $slang_version -lt $required_slang_version_as_int ; then
   AC_MSG_ERROR([S-Lang $1 or greater is required for this software])
fi
SLANG_VERSION=$slang_version
SLANG_LIB_STATIC=`echo $SLANG_LIB| cut -c 3-`/libslang.a
AC_SUBST(SLANG_LIB_STATIC)
AC_SUBST(SLANG_VERSION)

JD_SLANG_MODULE_INSTALL_DIR
])dnl }}}

AC_DEFUN(JD_INIT,dnl {{{
[
#These variable are initialized by JD init function
CONFIG_DIR=`pwd`
cd $srcdir
if test "`pwd`" != "$CONFIG_DIR"
then 
  AC_MSG_ERROR("This software does not support configuring from another directory.   See the INSTALL file")
fi

AC_SUBST(CONFIG_DIR)dnl
# Note: these will differ if one is a symbolic link
if test -f /usr/bin/dirname; then
  JD_Above_Dir=`dirname $CONFIG_DIR`
else
# system is a loser
  JD_Above_Dir=`cd ..;pwd`
fi
JD_Above_Dir2=`cd ..;pwd`
])dnl}}}

AC_DEFUN(JD_SET_OBJ_SRC_DIR, dnl {{{
[
#---------------------------------------------------------------------------
# Set the source directory and object directory.   The makefile assumes an
# abcolute path name.  This is because src/Makefile cds to OBJDIR and compiles
# the src file which is in SRCDIR
#---------------------------------------------------------------------------
SRCDIR=$CONFIG_DIR
if test "$1" != "."
then
  if test -z "$1"
  then
    SRCDIR=$SRCDIR/src
  else
    SRCDIR=$SRCDIR/$1
  fi
fi

OBJDIR=$SRCDIR/"$ARCH"objs
SODIR=$SRCDIR/shared"$ARCH"objs
AC_SUBST(SRCDIR)dnl
AC_SUBST(OBJDIR)dnl
AC_SUBST(SODIR)dnl
])dnl}}}

dnl  RPATH (-R or -rpath) handling {{{

RPATH=""
AC_SUBST(RPATH)dnl

AC_DEFUN(JD_INIT_RPATH,
[
case "$host_os" in
  *linux*|*solaris* )
    if test "X$GCC" = Xyes ; then
      if test "X$ac_R_nospace" = "Xno" ; then
        RPATH="-Wl,-R,"
      else
        RPATH="-Wl,-R"
      fi
    else
      if test "X$ac_R_nospace" = "Xno" ; then
        RPATH="-R "
      else
	RPATH="-R"
      fi
    fi
  ;;
  *osf*)
    if test "X$GCC" = Xyes
    then
      RPATH="-Wl,-rpath,"
    else
      RPATH="-rpath "
    fi
  ;;
esac
])

AC_DEFUN(JD_SET_RPATH,
[
if test "X$1" != "X"
then
  if test "X$RPATH" = "X"
  then 
    JD_INIT_RPATH
    if test "X$RPATH" != "X"
    then
      RPATH="$RPATH$1"
    fi
  else
    RPATH="$RPATH:$1"
  fi
fi
])
dnl }}}

dnl C / C++ compiler settings {{{

AC_DEFUN(GCC_WARNINGS,
[
dnl This originated from JD_GCC_WARNINGS
AC_ARG_ENABLE(warnings,
	      [  --enable-warnings       turn on GCC compiler warnings],
	      [gcc_warnings=$enableval])
if test "$GCC" = yes ; then
  CFLAGS="$CFLAGS -fno-strength-reduce -fno-strict-aliasing"
  if test -n "$gcc_warnings" ; then

  CFLAGS="$CFLAGS -Wall -W -pedantic -Winline -Wmissing-prototypes \
 -Wnested-externs -Wpointer-arith -Wcast-align -Wshadow -Wstrict-prototypes"
    # Now trim excess whitespace
    CFLAGS=`echo $CFLAGS`
  else
    # Always ensure that at least -Wall is specified for all GCC compiles
	case " $CFLAGS " in
	   *[\	\ ]-Wall[\	\ ]*) ;;
	   *) CFLAGS="$CFLAGS -Wall" ;;
	esac
  fi
fi
])

IEEE_CFLAGS=""
dnl-------------------------------------------------------------------------
AC_DEFUN(JD_IEEE_CFLAGS,
[
case "$host_cpu" in
  *alpha* )
    if test "$GCC" = yes
    then
      IEEE_CFLAGS="-mieee"
    else
      IEEE_CFLAGS="-ieee_with_no_inexact"
    fi
    ;;
  * )
    IEEE_CFLAGS=""
esac
])

AC_DEFUN(JD_ANSI_CC,
[

AC_PROG_CC
AC_PROG_CPP
AC_PROG_GCC_TRADITIONAL
AC_ISC_POSIX
AC_AIX

dnl #This stuff came from Yorick config script
dnl
dnl # HPUX needs special stuff
dnl
AC_EGREP_CPP(yes,
[#ifdef hpux
  yes
#endif
], [
AC_DEFINE(_HPUX_SOURCE)
if test "$CC" = cc; then CC="cc -Ae"; fi
])dnl
dnl
dnl #Be sure we've found compiler that understands prototypes
dnl
AC_MSG_CHECKING(C compiler that understands ANSI prototypes)
AC_TRY_COMPILE([ ],[
 extern int silly (int);], [
 AC_MSG_RESULT($CC looks ok.  Good.)], [
 AC_MSG_RESULT($CC is not a good enough compiler)
 AC_MSG_ERROR(Set env variable CC to your ANSI compiler and rerun configure.)
 ])dnl
])dnl
dnl #----------------------------------------------------------------------


AC_DEFUN(MN_GET_SO_SETTINGS,  dnl {{{
[
dnl #---------------------------------------------------------------------
dnl # Check for shared object/dynamic linker
dnl #---------------------------------------------------------------------
DYNAMIC_LINK_LIB=""
AC_CHECK_HEADER(dlfcn.h,[
  AC_DEFINE(HAVE_DLFCN_H)
  AC_CHECK_LIB(dl,dlopen,[
    DYNAMIC_LINK_LIB="-ldl"
    AC_DEFINE(HAVE_DLOPEN)
   ],[
    AC_CHECK_FUNC(dlopen,AC_DEFINE(HAVE_DLOPEN))
    if test "$ac_cv_func_dlopen" != yes
    then
      AC_MSG_WARN(cannot perform dynamic linking)
    fi
   ])])
AC_SUBST(DYNAMIC_LINK_LIB)

SO="\$(MODULE)"
SO_MAJOR_VER=1
SO_MINOR_VER=0.0
SO_MAJOR_NAME="\$(SO).\$(SO_MAJOR_VER)"

dnl # ---------------------------------------------------------------------
dnl # Add path to CC, for robust makes on systems with many compilers
dnl # ---------------------------------------------------------------------

dnl CC_PATH=`AS_DIRNAME([$CC])`
dnl AX_PATH_PROG([CC],`basename $CC`, $CC, $CC_PATH)

STRIP="strip"		dnl default to standard UNIX / X11 settings
SH_EXT=.so
PATH_SEP=$PATH_SEPARATOR

AC_PROG_CXX

PIC_FLAG=-fPIC		# default to linux/gcc setting for dynamic code
SO_CFLAGS="\$(CFLAGS)"
C_LINK="\$(CC) \$(SO_LINK_FLAGS)"
CXX_LINK="\$(CXX) \$(SO_LINK_FLAGS)"
DYNAMIC_LINK_FLAGS=

case "$host_os" in

  *linux* | *gnu*)		dnl {{{

    CC_SHARED="\$(CC) \$(CFLAGS) -shared"
    SO_LINK_FLAGS="-shared -Wl,-soname,\$(SO_MAJOR_NAME)"

    if test "$GCC" = yes ; then
	DYNAMIC_LINK_FLAGS="-Wl,-export-dynamic"
	SO_DEP_LIBS="\$(DL_LIB) -lm -lc"
    else
	SO_DEP_LIBS="\$(DL_LIB)"
    fi
    ;;	dnl }}}

  *solaris* )	dnl {{{

    CC_SHARED="\$(CC) \$(CFLAGS) -G"
    SO_DEP_LIBS="\$(DL_LIB) -lm -lc"

    if test "$GCC" = yes ; then
      SO_LINK_FLAGS="-shared -Wl,-ztext -Wl,-h,\$(SO_MAJOR_NAME)"
    else
      PIC_FLAG="-KPIC"
      SO_LINK_FLAGS="-G -h\$(SO_MAJOR_NAME)"

      if test `basename $CXX` != "CC"; then
	AC_MSG_ERROR(only Solaris CC compiler supported in this context)
      fi

      CXX_VERSION=`$CXX -V 2>&1| sed "s/.*\([[1-9]][[1-9]]*\.[[1-9]][[1-9\]]*\).*/\1/"`
      case $CXX_VERSION in
       3*) AC_MSG_ERROR(compiler is too old);;
       4*) CXX_LIBS="-lC";;
       *)  CXX_LIBS="-lCstd -lCrun";;
      esac

    fi
    ;;	dnl }}}

  *sco3.2v5* | *unixware-5* | *sco-sysv5uw7*)   dnl {{{

     # osr5 or unixware7 with current or late autoconf

     SO_DEP_LIBS=
     CC_SHARED="\$(CC) \$(CFLAGS) -G"

     if test "$GCC" = yes ; then 
       SO_LINK_FLAGS="-shared -Wl,-h,\$(SO_MAJOR_NAME)"
     else
       PIC_FLAG="-K pic"
       SO_LINK_FLAGS="-G -z text -h\$(SO_MAJOR_NAME)"
     fi
     ;;  dnl }}}

  *irix6.5* )   dnl {{{

     echo "Note: Shared-object compiler for host_os=$host_os may not be correct"
     echo "double-check: 'mode_t', 'pid_t' may be wrong!"

     CC_SHARED="\$(CC) \$(CFLAGS) -shared"
     SO_DEP_LIBS=

     if test "$GCC" = yes ; then 
       # not tested
       SO_LINK_FLAGS="-shared -Wl,-h,\$(SO_MAJOR_NAME)"
     else
       PIC_FLAG="-K pic"
       SO_LINK_FLAGS="-shared -o \$(SO_MAJOR_NAME)"
     fi
     ;;  dnl }}}

  *darwin* )   dnl {{{

     PIC_FLAG=
     STRIP=":"
     DYNAMIC_LINK_FLAGS=""
     SO_CFLAGS="$SO_CFLAGS -fno-common"
     dnl Darwin linker doesn't like -compatibility_version of 0, so we omit it
     SO_LINK_FLAGS="-dynamiclib -single_module -install_name \$(MODULE_INSTALL_DIR)/\$(SO_MAJOR_NAME) -current_version \$(SO_MAJOR_VER).\$(SO_MINOR_VER)"

     SO_DEP_LIBS="$LDFLAGS \$(DL_LIB)"
     CC_SHARED="\$(CC) -bundle -flat_namespace -undefined suppress \$(CFLAGS) -fno-common"
     ;;  dnl }}}

  *cygwin* )   dnl {{{
    SH_EXT=.dll.a
    PIC_FLAG=
    SO_LINK_FLAGS="-shared"
    SO_DEP_LIBS="\$(DL_LIB) -lm"
    CC_SHARED="\$(CC) \$(CFLAGS) -shared"
    ;;  dnl }}}

  *mingw* )   dnl {{{

    PIC_FLAG=
    SH_EXT=.dll
    SO_LINK_FLAGS="-shared"
    SO_DEP_LIBS="\$(DL_LIB) -lm"
    CC_SHARED="\$(CC) \$(CFLAGS) -shared"
    dnl avoid Unix/Win CR/LF issues
    COLLAPSE_BLANKS_FOR_REGR_TESTS="-b"
    CONFIG_DIR=`pwd -W`
    PATH_SEP=';'
    ;;  dnl }}}

  * )   dnl {{{

    STRIP=":"
    echo "Note: Shared object compiler for host_os=$host_os may be wrong"
    SO_LINK_FLAGS="-shared"
    SO_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="\$(CC) \$(CFLAGS) -shared"
    ;;  dnl }}}

esac

SO_CFLAGS="$SO_CFLAGS $PIC_FLAG"
CC_SHARED="$CC_SHARED $PIC_FLAG"

AC_SUBST(PIC_FLAG)
AC_SUBST(C_LINK)
AC_SUBST(CXX_LINK)
AC_SUBST(CXX_LIBS)
AC_SUBST(DYNAMIC_LINK_FLAGS)
AC_SUBST(CC_SHARED)
AC_SUBST(SO)
AC_SUBST(SO_MAJOR_NAME)
AC_SUBST(SO_MAJOR_VER)
AC_SUBST(SO_MINOR_VER)
AC_SUBST(SO_CFLAGS)
AC_SUBST(SO_LINK_FLAGS)
AC_SUBST(SO_DEP_LIBS)
AC_SUBST(STRIP)
AC_SUBST(SH_EXT)
AC_SUBST(COLLAPSE_BLANKS_FOR_REGR_TESTS)
AC_SUBST(PATH_SEP)
]) dnl }}}

AC_DEFUN(AC_CC_DEBUG_INFO, dnl {{{
[
AC_ARG_ENABLE(ccdebug,
	      [  --enable-ccdebug	  include -g debug info in ALL compiled C code],
	      [ccdebug=$enableval])

if test -n "$ccdebug" ; then
    cflags_has_dash_g=`echo $CFLAGS | grep -w "\-g"`
    if test -z "$cflags_has_dash_g" ; then
	CFLAGS="-g $CFLAGS"
    fi
    SO_CFLAGS="-g $SO_CFLAGS"
fi
])dnl }}}
dnl }}}

AC_DEFUN(JD_UPPERCASE, dnl#{{{
[
changequote(<<, >>)dnl
define(<<$2>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
])
#}}}

dnl# This macro process the --with-xxx, --with-xxxinc, and --with-xxxlib
dnl# command line arguments and returns the values as shell variables
dnl# jd_xxx_include_dir and jd_xxx_library_dir.  It does not perform any
dnl# substitutions, nor check for the existence of the supplied values.
AC_DEFUN(JD_WITH_LIBRARY_PATHS, dnl#{{{
[
 JD_UPPERCASE($1,JD_ARG1)
 jd_$1_include_dir=""
 jd_$1_library_dir=""
 jd_with_$1_library=""

 AC_ARG_WITH($1,
  [  --with-$1=DIR      Use DIR/lib and DIR/include for $1],
  [jd_with_$1_arg=$withval], [jd_with_$1_arg=unspecified])
  
 case "x$jd_with_$1_arg" in
   xno)
     jd_with_$1_library="no"
    ;;
   x)
    AC_MSG_ERROR(--with-$1 requires a value-- try yes or no)
    ;;
   xunspecified)
    ;;
   xyes)
    ;;
   *)
    jd_$1_include_dir="$jd_with_$1_arg"/include
    jd_$1_library_dir="$jd_with_$1_arg"/lib
    ;;
 esac

 AC_ARG_WITH($1lib,
  [  --with-$1lib=DIR   $1 library in DIR],
  [jd_with_$1lib_arg=$withval], [jd_with_$1lib_arg=unspecified])
 case "x$jd_with_$1lib_arg" in
   xunspecified)
    ;;
   xno)
    ;;
   x)
    AC_MSG_ERROR(--with-$1lib requres a value)
    ;;
   *)
    jd_$1_library_dir="$jd_with_$1lib_arg"
    ;;
 esac

 AC_ARG_WITH($1inc, 
  [  --with-$1inc=DIR   $1 include files in DIR],
  [jd_with_$1inc_arg=$withval], [jd_with_$1inc_arg=unspecified])
 case "x$jd_with_$1inc_arg" in
   x)
     AC_MSG_ERROR(--with-$1inc requres a value)
     ;;
   xunspecified)
     ;;
   xno)
     ;;
   *)
    jd_$1_include_dir="$jd_with_$1inc_arg"
   ;;
 esac
])
dnl#}}}

dnl# This function checks for the existence of the specified library $1 with
dnl# header file $2.  If the library exists, then the shell variables will
dnl# be created: 
dnl#  jd_with_$1_library=yes/no, 
dnl#  jd_$1_inc_file
dnl#  jd_$1_include_dir
dnl#  jd_$1_library_dir
AC_DEFUN(JD_CHECK_FOR_LIBRARY, dnl#{{{
[
  AC_REQUIRE([JD_EXPAND_PREFIX])dnl
  AC_MSG_CHECKING(for the $1 library and header files $2)
  dnl JD_UPPERCASE($1,JD_ARG1)
  JD_WITH_LIBRARY_PATHS($1)
  if test X"$jd_with_$1_library" = X
  then
    jd_$1_inc_file=$2
    jd_with_$1_library="yes"

    if test "X$jd_$1_inc_file" = "X"
    then
       jd_$1_inc_file=$1.h
    fi
    if test X"$jd_$1_include_dir" = X
    then
       lib_include_dirs="\
            $jd_prefix_incdir \
            /usr/local/$1/include \
            /usr/local/include/$1 \
  	  /usr/local/include \
  	  /usr/include/$1 \
  	  /usr/$1/include \
  	  /usr/include \
  	  /opt/include/$1 \
  	  /opt/$1/include \
  	  /opt/include"
  
       for X in $lib_include_dirs
       do
          if test -r "$X/$jd_$1_inc_file"
	  then
  	  jd_$1_include_dir="$X"
            break
          fi
       done
       if test X"$jd_$1_include_dir" = X
       then
         jd_with_$1_library="no"
       fi
    fi
   
    if test X"$jd_$1_library_dir" = X
    then
       lib_library_dirs="\
            $jd_prefix_libdir \
            /usr/local/lib \
            /usr/local/lib/$1 \
            /usr/local/$1/lib \
  	  /usr/lib \
  	  /usr/lib/$1 \
  	  /usr/$1/lib \
  	  /opt/lib \
  	  /opt/lib/$1 \
  	  /opt/$1/lib"

	case "$host_os" in
         *darwin* )
           exts="dylib so a"
           ;;
         *cygwin* )
           exts="dll.a so a"
           ;;
         * )
           exts="so a"
	esac 
  
       for X in $lib_library_dirs ; do
	   for E in $exts ; do
		if test -r "$X/lib$1.$E" ; then
		   jd_$1_library_dir="$X"
		   break
		fi
	   done
       done

       if test X"$jd_$1_library_dir" = X
       then
         jd_with_$1_library="no"
       fi
    fi
  fi

  if test "$jd_with_$1_library" = "yes"
  then
    AC_MSG_RESULT(yes: $jd_$1_library_dir and $jd_$1_include_dir)
    dnl#  Avoid using /usr/lib and /usr/include because of problems with
    dnl#  gcc on some solaris systems.
    JD_ARG1[]_LIB=-L$jd_$1_library_dir
    if test "X$jd_$1_library_dir" = "X/usr/lib"
    then
      JD_ARG1[]_LIB=""
    else
      JD_SET_RPATH($jd_$1_library_dir)
    fi

    JD_ARG1[]_INC=-I$jd_$1_include_dir
    if test "X$jd_$1_include_dir" = "X/usr/include"
    then
      JD_ARG1[]_INC=""
    fi
  else
    AC_MSG_RESULT(no)
    JD_ARG1[]_INC=""
    JD_ARG1[]_LIB=""
  fi
  AC_SUBST(JD_ARG1[]_LIB)
  AC_SUBST(JD_ARG1[]_INC)
])
dnl#}}}

AC_DEFUN(JD_WITH_LIBRARY, dnl#{{{
[
  JD_CHECK_FOR_LIBRARY($1, $2)
  if test "$jd_with_$1_library" = "no"
  then
    AC_MSG_ERROR(unable to find the $1 library and header file $jd_$1_inc_file)
  fi
])
dnl#}}}

AC_DEFUN(AC_FIND_SLSH, dnl {{{
[
   AX_PATH_PROG([SLSH],[slsh],[])
   if test -z "$SLSH" ; then
	dnl default to using slsh bundled/built with SLIRP/SLgtk
	dnl (requires prior invocation of JD_INIT)
	SLSH=$CONFIG_DIR/slsh
   else
	SLSH_LOAD_PATH=`$SLSH -n <<EOT
vmessage("%S",get_slang_load_path());
EOT`
   fi
AC_SUBST(SLSH)
AC_SUBST(SLSH_LOAD_PATH)
])dnl }}}

AC_DEFUN(AC_GET_DATE, dnl {{{
[
  AX_PATH_PROG([DATE],[date],[])
  if test -n "$DATE" ; then
	date=`${DATE}`
  else
	date=unknown
  fi
  AC_SUBST(date)
])dnl }}}

AC_DEFUN(SAFE_AC_PROG_FC, dnl {{{
[
   AC_REQUIRE([MN_GET_SO_SETTINGS]) dnl mainly for PIC_FLAG
   dnl The AC_PROG_FC macro in autoconf 2.59 is broken, in that it aborts when
   dnl a FORTRAN compiler cannot be found, instead of simply setting FC=""
   pushdef([AC_MSG_ERROR], [HAVE_FC=0])
   AC_PROG_FC
   if test -z "$FC" || test "X$FC" = "Xno"; then
	FC=
	HAVE_FC=0
   else
	HAVE_FC=1
	FCFLAGS="$FCFLAGS $PIC_FLAG"
   fi
   popdef([AC_MSG_ERROR])
   AC_SUBST(HAVE_FC)
])dnl }}}

AC_DEFUN(SAFE_AC_FC_LIBRARY_LDFLAGS, dnl {{{
[
   AC_REQUIRE([SAFE_AC_PROG_FC])
   AC_REQUIRE([AC_FC_LIBRARY_LDFLAGS])
   dnl Solaris OpenMP stubs library must appear last on link line
   dnl when linking mixed C/FORTRAN codes with C compiler, but
   dnl the linker -v flag doesn't do this; so we fix it here
   _AC_LIST_MEMBER_IF(-lompstubs, $FCLIBS, [
	FCLIBS=`echo $FCLIBS | sed 's/-lompstubs//g'`
	FCLIBS="$FCLIBS -lompstubs" ]
	)
])dnl }}}

AC_DEFUN(SAFE_AC_FC_MANGLE, dnl {{{
[
   AC_REQUIRE([SAFE_AC_FC_LIBRARY_LDFLAGS])
   pushdef([AC_MSG_ERROR], [FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX= ; FC_MANGLE_EXTRA_USCORE=0; FCRPATH= ;])
   if test $HAVE_FC -eq 1 ; then
	AC_FC_WRAPPERS
	AC_FC_FUNC(a)
	case $a in
	   A)	FC_MANGLE_UPCASE=1; FC_MANGLE_SUFFIX="";;
	   A_)	FC_MANGLE_UPCASE=1; FC_MANGLE_SUFFIX="_";;
	   A__)	FC_MANGLE_UPCASE=1; FC_MANGLE_SUFFIX="__";;
	   a)	FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="";;
	   a_)	FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="_";;
	   a__)	FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="__";;
	   *)	AC_MSG_WARN([unknown Fortran mangling convention])
		FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="_"
		;;
	esac

	AC_FC_FUNC(_,a)
	case $a in
	_${FC_MANGLE_SUFFIX})   FC_MANGLE_EXTRA_USCORE=0;;
	_${FC_MANGLE_SUFFIX}_)  FC_MANGLE_EXTRA_USCORE=1;;
	*)   AC_MSG_WARN([unknown Fortran extra-underscore mangling convention])
	     FC_MANGLE_EXTRA_USCORE=0;;
	esac

	SAVE_RPATH=$RPATH
	RPATH=""
	for l in $FCLIBS; do
	   opt=`echo $l | cut -c1-2`
	   if test "$opt" = "-L" ; then
		JD_SET_RPATH(`echo $l | cut -c3-`)
	   else
		FCLIBS_NAMES="$FCLIBS_NAMES $l"
	   fi
	done
	FCRPATH=$RPATH
	RPATH=$SAVE_RPATH
   fi
   popdef([AC_MSG_ERROR])
   AC_SUBST(FC_MANGLE_UPCASE)
   AC_SUBST(FC_MANGLE_SUFFIX)
   AC_SUBST(FC_MANGLE_EXTRA_USCORE)
   AC_SUBST(FCRPATH)
   AC_SUBST(FCLIBS_NAMES)
])dnl }}}

AC_DEFUN(GET_TYPE_MNEMONIC_I, dnl {{{
[
  case $2 in
	1)  $1[]_mnemonic=$3char;;
	$ac_cv_sizeof_short) $1[]_mnemonic=$3short;;
	$ac_cv_sizeof_int) $1[]_mnemonic=$3int ;;
	$ac_cv_sizeof_long) $1[]_mnemonic=$3long ;;
	$ac_cv_sizeof_long_long) $1[]_mnemonic=$3llong;;
	*) AC_MSG_ERROR([could not determine type mnemonic for $1]);;
  esac
  AC_SUBST($1[]_mnemonic)
])
dnl }}}

AC_DEFUN(GET_TYPE_MNEMONIC_R, dnl {{{
[
  case $2 in
	$ac_cv_sizeof_float) $1[]_mnemonic=float ;;
	$ac_cv_sizeof_double) $1[]_mnemonic=double;;
	$ac_cv_sizeof_long_double) $1[]_mnemonic=ldouble;;
	*)  $1[]_mnemonic=unsupported;;
  esac
  AC_SUBST($1[]_mnemonic)
])
dnl }}}

AC_DEFUN(AC_SLIRP_FINALIZE, dnl {{{
[
   if ! test -s VERSION ; then
	AC_MSG_ERROR([could not find VERSION file])
   fi

   AC_SUBST(nvec)
   AC_ARG_WITH(nvec,
      [  --with-nvec=NUM		Set maximum number of function arguments
				which may be vectorized (default==10)],
	nvec=$withval, nvec=10)

   JD_UPPERCASE(AC_PACKAGE_NAME,MODULE_NAME)

   MAJOR_VERSION=`cat VERSION | cut -d. -f1`
   MINOR_VERSION=`cat VERSION | cut -d. -f2`
   MICRO_VERSION=`cat VERSION | cut -d. -f3`

   MODULE_NAME[]_VERSION_STRING=${MAJOR_VERSION}.${MINOR_VERSION}.${MICRO_VERSION}
   MODULE_NAME[]_VERSION=`expr \( 10000 \* $MAJOR_VERSION \) + \( 100 \* $MINOR_VERSION \) + $MICRO_VERSION`

   if test -n "$DEVEL_BUILD" ; then
	DEVEL_BUILD=true
   fi

   if test -f REVISION ; then
	REVISION=`cat REVISION | grep -v \#`
   else
	REVISION=
   fi
   MODULE_NAME[]_REVISION=$REVISION

   AC_SUBST(MODULE_NAME[]__VERSION)
   AC_SUBST(MODULE_NAME[]_VERSION_STRING)
   AC_SUBST(MODULE_NAME[]_REVISION)
   AC_SUBST(DEVEL_BUILD)
   AC_DEFINE_UNQUOTED(MODULE_NAME[]_VERSION,$MODULE_NAME[]_VERSION)
   AC_DEFINE_UNQUOTED(MODULE_NAME[]_VERSION_STRING,"$MODULE_NAME[]_VERSION_STRING")
   SLIRP_URL=http://space.mit.edu/cxc/slirp
   AC_SUBST(SLIRP_URL)

   AC_CHECK_HEADER(stdint.h, HAVE_STDINT_H=1, HAVE_STDINT_H=0)
   AC_SUBST(HAVE_STDINT_H)

   AC_CHECK_SIZEOF(short)
   AC_CHECK_SIZEOF(int)
   AC_CHECK_SIZEOF(long)
   AC_CHECK_SIZEOF(long long)
   AC_CHECK_SIZEOF(unsigned long long)
   AC_CHECK_SIZEOF(float)
   AC_CHECK_SIZEOF(double)
   AC_CHECK_SIZEOF(long double)
   AC_CHECK_SIZEOF(char *)
   AC_CHECK_SIZEOF(ptrdiff_t)
   AC_CHECK_SIZEOF(size_t)

   AX_OPENMP
   AC_SUBST(OPENMP_CFLAGS)	dnl assume same flags used for C++
   if test -n "$OPENMP_CFLAGS" ; then
	AC_MSG_CHECKING(that supported OpenMP specification is 2.0 or later)
	_save_cflags=$CFLAGS
	CFLAGS="$OPENMP_CFLAGS $CFLAGS"
	AC_TRY_RUN([int main() { if (_OPENMP >= 200000) return 0; return 1; }],
	   AC_MSG_RESULT(yes),
	   [AC_MSG_RESULT([no, OpenMP will not be used]) ; OPENMP_CFLAGS= ])
	CFLAGS=$_save_cflags
   fi

   GET_TYPE_MNEMONIC_I(ptrdiff_t, $ac_cv_sizeof_ptrdiff_t)
   GET_TYPE_MNEMONIC_I(size_t, $ac_cv_sizeof_size_t, u)
   GET_TYPE_MNEMONIC_I(int16, 2)
   GET_TYPE_MNEMONIC_I(uint16, 2, u)
   GET_TYPE_MNEMONIC_I(int32, 4)
   GET_TYPE_MNEMONIC_I(uint32, 4, u)
   GET_TYPE_MNEMONIC_I(int64, 8)
   GET_TYPE_MNEMONIC_I(uint64, 8, u)
   GET_TYPE_MNEMONIC_I(long_long, $ac_cv_sizeof_long_long)
   GET_TYPE_MNEMONIC_I(ulong_long, $ac_cv_sizeof_long_long, u)

   AC_LANG_PUSH(C++)
   AC_CHECK_SIZEOF(bool)
   AC_LANG_POP()

   if test $ac_cv_sizeof_bool -eq 0 ; then
	ac_cv_sizeof_bool=1
   fi
   GET_TYPE_MNEMONIC_I(bool, $ac_cv_sizeof_bool)
   GET_TYPE_MNEMONIC_R(float32, 4)
   GET_TYPE_MNEMONIC_R(float64, 8)
   GET_TYPE_MNEMONIC_R(float96, 12)
   test $ac_cv_sizeof_long_long -eq 0
   HAVE_LONG_LONG=$?
   AC_SUBST(HAVE_LONG_LONG)

   AX_PATH_PROG(SET_SECURITY,chcon,touch)dnl check for SELinux security
   if test "$SET_SECURITY" != "touch" ; then
	SET_SECURITY="$SET_SECURITY -t texrel_shlib_t"
   fi
   AC_SUBST(SET_SECURITY)

   dnl Use full path to compilers, to avoid crosstalk in generated Makefiles
   dnl on systems with multiple compilers (can be overridden at 'make' time)
   COMPILER_PATH=`AS_DIRNAME([$CC])`
   AX_PATH_PROG([CC],`basename $CC`, $CC, $COMPILER_PATH)
   COMPILER_PATH=`AS_DIRNAME([$CXX])`
   AX_PATH_PROG([CXX],`basename $CXX`, $CXX, $COMPILER_PATH)
   COMPILER_PATH=`AS_DIRNAME([$FC])`
   AX_PATH_PROG([FC],`basename $FC`, $FC, $COMPILER_PATH)

   # Solaris requires -xO3 optimization for OpenMP & that apps into which
   # OpenMP-aware dynamic libs will be loaded ALSO be linked with OpenMP
   if test "$OPENMP_CFLAGS" = "-xopenmp" ; then
	LDFLAGS="$OPENMP_CFLAGS $LDFLAGS"
	CFLAGS="$CFLAGS -xO3"
   fi
])
dnl }}}
