#include "beosdir.h"
#include <dirent.h>
#include <Errors.h>

#include <errno.h>

#include "directory.h"
#include "slatevm.h"

#define BYTEARRAY_LEN(x)	(PSObject_payloadSize((struct Object *) (x)))


int
openDirectory(struct ByteArray *dirName)
{
	int dirHandle;
	size_t nameLen = BYTEARRAY_LEN(dirName);
	char *name = malloc(nameLen + 1);
	
	if (name == NULL)
		return B_NO_MEMORY;
	else {
		memcpy(name, dirName->elements, nameLen);
		name[nameLen] = '\0';
		dirHandle = beosOpenDirectory(name);
		free(name);
		
		return dirHandle;
	}
}


int
readDirectory(int dirHandle, struct ByteArray *entNameBuffer)
{
	int resultCode, entLen;
	struct dirent ent;
	
	if (dirHandle < 0)
		return B_BAD_VALUE;
	
	resultCode = beosReadDirectory(dirHandle, &ent);
	
	if (resultCode == B_ENTRY_NOT_FOUND)
		return 0;
	else if (resultCode != 0)
		return resultCode;
	
	entLen = strlen(ent.d_name);
	if (entLen == 0)
		return B_ENTRY_NOT_FOUND;
	
	assert(BYTEARRAY_LEN(entNameBuffer) >= entLen);
	memcpy(entNameBuffer->elements, ent.d_name, entLen);
	return entLen;
}


int getCurrentDirectory(struct ByteArray *wdBuffer) {
  if (getcwd(wdBuffer->elements, BYTEARRAY_LEN(wdBuffer)) == NULL)
    return -errno;

  return strlen(wdBuffer->elements);
}

int setCurrentDirectory(struct ByteArray *newWd) {
  size_t wdLen = BYTEARRAY_LEN(newWd);
  char *wd = malloc(wdLen + 1);
  if (wd == NULL)
    return -errno;

  memcpy(wd, newWd->elements, wdLen);
  wd[wdLen] = '\0';
  if (chdir(wd) == -1) {
    int savedErrno = errno;
    free(wd);
    return -savedErrno;
  } else {
    free(wd);
    return 0;
  }
}
