/*
 * The Sleuth Kit
 *
 * $Date: 2005/09/02 23:34:04 $
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003-2005 Brian Carrier.  All rights reserved
 *
 * mm_open - wrapper function for specific partition type
 *
 *
 * This software is distributed under the Common Public License 1.0
 *
 */

#include "mm_tools.h"


/* 
 * THe main wrapper function for opening an image
 */
MM_INFO *
mm_open(IMG_INFO * img_info, const char *type, DADDR_T offset)
{
    /* Autodetect mode 
     * We need to try all of them in case there are multiple 
     * installations
     */
    if (type == NULL) {
	MM_INFO *mm_info, *mm_set = NULL;
	char *set = NULL;

	if ((mm_info = dos_open(img_info, offset, 1)) != NULL) {
	    set = "DOS";
	    mm_set = mm_info;
	}
	if ((mm_info = bsd_open(img_info, offset, 1)) != NULL) {
	    // if (set == NULL) {
	    // In this case, BSD takes priority because BSD partitions start off with
	    // the DOS magic value in the first sector with the boot code.
	    set = "BSD";
	    mm_set = mm_info;
	    /*
	       }
	       else {
	       mm_set->close(mm_set);
	       mm_info->close(mm_info);
	       error("Cannot determine if BSD or %s at %"PRIuDADDR"", set, offset);
	       }
	     */
	}
	if ((mm_info = gpt_open(img_info, offset, 1)) != NULL) {
	    if (set == NULL) {
		set = "GPT";
		mm_set = mm_info;
	    }
	    else {
		mm_set->close(mm_set);
		mm_info->close(mm_info);
		error("Cannot determine if GPT or %s at %" PRIuDADDR "",
		      set, offset);
	    }
	}
	if ((mm_info = sun_open(img_info, offset, 1)) != NULL) {
	    if (set == NULL) {
		set = "Sun";
		mm_set = mm_info;
	    }
	    else {
		mm_set->close(mm_set);
		mm_info->close(mm_info);
		error("Cannot determine if Sun or %s at %" PRIuDADDR "",
		      set, offset);
	    }
	}
	if ((mm_info = mac_open(img_info, offset, 1)) != NULL) {
	    if (set == NULL) {
		set = "Mac";
		mm_set = mm_info;
	    }
	    else {
		mm_set->close(mm_set);
		mm_info->close(mm_info);
		error("Cannot determine if Mac or %s at %" PRIuDADDR "",
		      set, offset);
	    }
	}

	return mm_set;
    }
    else {
	uint8_t mmtype;

	/* Transate the string into the number */
	mmtype = mm_parse_type(type);

	switch (mmtype) {
	case MM_DOS:
	    return dos_open(img_info, offset, 0);
	case MM_MAC:
	    return mac_open(img_info, offset, 0);
	case MM_BSD:
	    return bsd_open(img_info, offset, 0);
	case MM_SUN:
	    return sun_open(img_info, offset, 0);
	case MM_GPT:
	    return gpt_open(img_info, offset, 0);
	case MM_UNSUPP:
	default:
	    fprintf(stderr, "unknown partition type: %s\n", type);
	    fprintf(stderr, "Supported types:\n");
	    mm_print_types(stderr);
	    return NULL;
	}
    }
}
