#include "aux_tools.h"
#include <stdarg.h>

/* 
 * These are printf wrappers that are needed so that we can
 * easily print in both Unix and Windows.  For Unix, the 
 * internal UTF-8 representation is kept and a normal printf
 * is performed.  For Windows, the UTF-8 representation is first
 * converted to UTF-16 and then printed
 */
void
tsk_fprintf(FILE * fd, char *msg, ...)
{
    va_list args;
    va_start(args, msg);

#ifdef TSK_WIN32
    {
	char cbuf[2048];
	WCHAR wbuf[2048];
	UTF8 *ptr8;
	UTF16 *ptr16;
	int retVal;
	size_t len;

	memset(cbuf, 0, 2048);
	memset(wbuf, 0, 2048 * sizeof(WCHAR));

	vsprintf_s(cbuf, 2048, msg, args);
	len = strlen(cbuf);

	//Convert to UTF-16
	ptr8 = (UTF8 *) cbuf;
	ptr16 = (UTF16 *) wbuf;
	retVal =
	    tsk_UTF8toUTF16(&ptr8, &ptr8[len + 1], &ptr16, &ptr16[2048],
	    lenientConversion);
	if (retVal != conversionOK) {
	    *ptr16 = '\0';
	    fwprintf(fd, _T("%s"), wbuf);
	    if (verbose)
		tsk_fprintf(stderr,
		    "tsk_fprintf: error converting string to UTF-16\n");
	}
	else {
	    fwprintf(fd, _T("%s"), wbuf);
	}
    }
#else
    vfprintf(fd, msg, args);
#endif
    va_end(args);
}

void
tsk_printf(char *msg, ...)
{
    va_list args;
    va_start(args, msg);

#ifdef TSK_WIN32
    {
	char cbuf[2048];
	WCHAR wbuf[2048];
	UTF8 *ptr8;
	UTF16 *ptr16;
	int retVal;
	size_t len;

	memset(cbuf, 0, 2048);
	memset(wbuf, 0, 2048 * sizeof(WCHAR));

	vsprintf_s(cbuf, 2048, msg, args);
	len = strlen(cbuf);

	//Convert to UTF-16
	ptr8 = (UTF8 *) cbuf;
	ptr16 = (UTF16 *) wbuf;
	retVal =
	    tsk_UTF8toUTF16(&ptr8, &ptr8[len + 1], &ptr16, &ptr16[2048],
	    lenientConversion);
	if (retVal != conversionOK) {
	    *ptr16 = '\0';
	    wprintf(_T("%s"), wbuf);
	    if (verbose)
		tsk_fprintf(stderr,
		    "tsk_printf: error converting string to UTF-16\n");
	}
	else {
	    wprintf(_T("%s"), wbuf);
	}
    }
#else
    vprintf(msg, args);
#endif
    va_end(args);
}
