# Script for compiling afflib
# as part of The Sleuth Kit
#
#
# $Date: 2006/12/06 17:32:51 $
#
#
cd afflib
if (test -f './Makefile') then
    true
else
    ./configure -enable-s3=no || (cd ..; exit $?)
fi

make -C lib

if (test -f 'lib/libafflib.a') then 
    mkdir afflib-tsk
    if (test -d 'afflib-tsk') then
	cp lib/libafflib.a afflib-tsk
	(cd afflib-tsk; ar x libafflib.a; cd ..)
	ar rv ../../lib/libtsk.a afflib-tsk/*.o
	rm -rf afflib-tsk
    else
	echo "Error creating tmp directory in afflib"
	cd ..
	exit 1
    fi
else
    echo "Error: Missing lib/libafflib.a file"
    cd ..
    exit 1
fi

cd ..
