#include "config.h"
#include "afflib.h"
#include "utils.h"


/* Given an AFFILE, return a seglist.
 * Returns -1 if failure, 0 if success.
 */
int get_seglist(AFFILE *af,seglist *slist)
{
    if(af_rewind_seg(af)) return -1;
    char name_[AF_MAX_NAME_LEN];
    size_t len_;
    while(af_get_next_seg(af,name_,sizeof(name_),0,0,&len_)==0){
	// We shouldn't have 0-len segments, but we do in some files.
	// Don't copy these segments.
	if(strlen(name_)>0){		
	    seginfo si(name_,len_);
	    slist->push_back(si);
	}
    }
    return 0;
}


