/*
 * utils.h:
 * Some useful utilities for building AFF-aware programs.
 */

#ifndef UTILS_H
#define UTILS_H

#include <algorithm>
#include <cstdlib>
#include <vector>
#include <string>
#include <map>

using namespace std;

/* Structure for hash map */
struct less_c_str
{
    inline bool operator()( const char* x, const char* y) const
    {     return ( strcmp( x,y ) < 0 );
    }
};

struct md5blob {
    unsigned char buf[16];
};

typedef map< const char*, struct md5blob, less_c_str > hashMapT;

/* Structure for seginfo list */
class seginfo {
public:
    seginfo(string n1,size_t l1): name(n1),len(l1) {}
    string name;
    size_t len;
    bool inline operator==(const seginfo &b) const {
	return name == b.name;
    }
};

typedef vector<seginfo> seglist;

class outelement {
public:
    outelement(){}
    AFFILE *af;			// where output goes
    seglist segs;			// list of existing segments in output
};
typedef vector<outelement> outlist;


int get_seglist(AFFILE *af,seglist *slist);

#endif
