
% This example exercises the SLgtk gprompt widget, which provides a Gtk-
% based SLang prompt with scrolling output and simple command history.

require("gprompt");

private define mylog(prompt, out_msg, id) % {{{
{
   % This custom log function tacks on a fictional ID tag and date stamp ...
   out_msg = sprintf("(%d) %s: %s\n", id, time(), out_msg);

   () = printf("%S", out_msg);	% ... and echoes the logged msg to stdout
   () = fflush(stdout);

   prompt.log_write(out_msg);
} % }}}

private define make_win(prompt, msg) % {{{
{
   variable win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(win, "gPrompt Example");
   gtk_window_set_default_size(win, 480, 320);
   () = g_signal_connect (win, "destroy", &gtk_main_quit);
      
   variable vbox = gtk_vbox_new (FALSE, 0);
   gtk_container_add (win, vbox);

   variable frame = gtk_frame_new(NULL);
   gtk_box_pack_start(vbox, frame, FALSE, FALSE, 0);

   gtk_container_add(frame, prompt.input_container);
   gtk_box_pack_start(vbox, prompt.output_container, TRUE, TRUE, 0);

   variable hbox = gtk_hbox_new(FALSE, 0);
   variable button = gtk_button_new_with_label("Quit");
   () = g_signal_connect_swapped (button, "clicked", &gtk_widget_destroy, win);
   gtk_container_add(hbox, button);
   gtk_box_pack_end(vbox, hbox, FALSE, FALSE, 0);

   g_object_set_data(prompt.input, "focus_next", button);

   gtk_widget_grab_focus(prompt.input);
   gtk_widget_show_all (win);

   prompt.intro();
   if (msg != NULL)
	prompt.log(msg);

   gtk_main();
} % }}}

define gprompt_example() % {{{
{
   make_win( gprompt_new(), );
   make_win( gprompt_new(&mylog, 5),
	"This second example shows one way to use a custom logger");
} % }}}

% Defining slsh_main lets GUI be launched immediately when invoked via: {{{
%
%                       slsh gprompt_example.sl
%
% The guilet may also be launched from S-Lang apps with dynamic linking via
%
%	require("gprompt_example");
%	gprompt_example;
%
% and variants.

define slsh_main() { gprompt_example; }

% }}}

provide("gprompt_example");
