
variable libs = String_Type[0];
variable dirs = String_Type[0];
variable archive = "";
variable shared  = "";

% This script produces aims at producing a list of libraries to be
% "statically linked" into a dynamically-loadable module.  Apparently
% the most portable way to do this, given that some linkers either do
% not support mixing of flags like -dynamic and -static (such as the
% non-GNU MAC OS/X ld) is to explicitly list each .a with a full path.

foreach(__argv[[1:]]) {
   variable arg = ();
   switch (arg[[0:1]])
   { case "-L" :
	%if ( length( where (dirs == arg) ) == 0)
	   dirs = [ dirs, arg ];
   }
   { case "-l" : 
	%if ( length( where (libs == arg) ) == 0)
	   libs = [ libs, arg ];
   }
}

foreach (libs) {
   variable path, lib = ();
   foreach(dirs) {
	variable dir = ();
	path = sprintf("%s/lib%s.a", dir[[2:]], lib[[2:]]);
	if (stat_file( path ) != NULL) {
	   archive = strcat(archive," ",path);
	   break;
	}
   }
   !if (is_substr(archive,path))
	shared = sprintf("%s %s",shared,lib);
}

if (archive == "" and shared == "")
   exit(1);		% indicate "failure" to find libs in given dirs

() = printf("%s %s\n",archive,shared);
exit(0);
