
_debug_info = 1;
_traceback  = 1;
_slangtrace = 1;

require("gtk");

variable testnames = [ % {{{
   "buttonbox",
   "buttons",
#ifeval _gtk_version >= 20800
   "cairo",
#endif
   "chained",
   "checkbuttons",
   %"clist",			% deprecated in Gtk 2
   "colorsel",
   %"ctree",			% deprecated in Gtk 2
   "cube",
   "cursors",
   "drawarea",
   "dialogs",
   "entry",
   "eventwatcher",
   "filesel",
   "fontsel",
   "gtkmainloop",
   "handlebox",
   "imagedisplay",
   "itemfactory",
   "labels",
   "layout",
   %"list",			% deprecated in Gtk 2
   "liststore",
   "menus",
   "modalwin",
   "notebook",
   "panes",
   "pixmap",			% deprecated in Gtk 2, but left active for now
   "plot",
   %"previewcolor",		% deprecated in Gtk 2
   %"previewgray",		% deprecated in Gtk 2
   "progbar",
   "radiob",
   "range",
   "rcfile",
   "rgbtest",
   "reparent",
   "rulers",
   "savedposition",
   "selection",
   "scrollwin",
   "shapes",
   "slgtktoolbox",
   "socket",
   "spinb",
   "statusbar",
   "testidle",
   %"text",			% deprecated in Gtk 2.x
   "textview",
   "timeout",
   "togglebuttons",
   "toolbar",
   "tooltips",
   %"tree",			% deprecated in Gtk 2.x
   "transparency",
   "viswhere",
   "wmhints"
]; % }}}

private variable SLgtkTest = struct { % {{{
   name,		% Name of widget test/example
   func,		% Callback for "clicked" signal on raise button 
   raise,		% Button on main window which raises/invokes test
   lower,		% Button (per test window) which lowers/dismisses test
   data			% place to stuff anything you'd like for this test
}; % }}}

define unsupported(ignored) % {{{
{
   message("unimplemented, or not migrated to Gtk 2.x yet");
}
variable unsupported_ref = &unsupported;
% }}}

define auto_lower(button) % {{{
{
   if (button != NULL)
	g_signal_emit_by_name(button,"clicked");
   return FALSE;
} % }}}

variable tests = Assoc_Type[Any_Type, NULL], _func;

define auto_raise(names, scroller) % {{{
{
   variable lower = (length(names) > 1);
   % Recall: page_size is the length of the scrollbar, and must be
   % subtracted so that the scrollbar stays w/in the allocation
   variable scroll_incr = (gtk_adjustment_get_upper(scroller) -
			gtk_adjustment_get_page_size(scroller) -
			gtk_adjustment_get_lower(scroller)) / length(testnames);

   foreach(names [ where (names != "gtkmainloop" and names != "socket") ] ) {

	variable name = ();
	variable test = tests[name];
	if (test != NULL) {

	   variable position = where(testnames == name)[0] * scroll_incr;
	   gtk_adjustment_set_value(scroller, position);

	   gtk_widget_grab_focus(test.raise);
	   g_signal_emit_by_name(test.raise,"clicked");

	   if (lower) {
		while (gtk_events_pending())
		   () = gtk_main_iteration_do(FALSE);
		() = g_timeout_add(3500, &auto_lower, test.lower);
		sleep(1);
	   }
	}
   }

   if (lower) {
	while (gtk_events_pending())
	   () = gtk_main_iteration_do(FALSE);
	gtk_main_quit();
   }
   return FALSE;
} % }}}

define create_test(name) % {{{
{
   variable test = @SLgtkTest;
   variable fname = path_concat(SLGTK_EXAMPLES_DIR, name)+ ".sl";

   test.name = name;
   if (stat_file(fname) != NULL) {
	() = evalfile(fname);
	eval(sprintf("_func = &create_%s",name));
	test.func = _func;
   }
   else
        test.func = unsupported_ref;

   return test;
} % }}}

define generic_close_button() % {{{
{
   variable container,func,window;
   switch (_NARGS)
      { case 2: (container,window) = (); func = &gtk_widget_destroy;}
      { case 3: (container,window,func) = (); }

   variable hsep = gtk_hseparator_new();
   gtk_box_pack_start(container,hsep,FALSE,FALSE,5);

   variable vbox = gtk_vbox_new (FALSE, 5);
   gtk_container_set_border_width (vbox, 5);
   gtk_box_pack_start(container,vbox,FALSE,FALSE,0);

   variable button = gtk_button_new_with_label("Close");
   () = g_signal_connect_swapped(button,"clicked",func,window);
   gtk_box_pack_start(vbox,button,FALSE,FALSE,0);
   gtk_widget_grab_focus(button);

   return button;
} % }}}

define display_stack() % {{{
{
   variable dumper = "";
   if (_NARGS == 1) { 
	dumper = ();
	dumper = sprintf("(dumped from <%S>)",dumper);
   }
   if (_stkdepth() > 0) {
	vmessage("STACK CONTENTS %S :\n",dumper);
	_print_stack();
	vmessage("\n>\n");
   } 
   else 
	vmessage("STACK CONTENTS %S : stack is empty",dumper);
} % }}}

define destroy_signal (widget, window) % {{{
{ 
   display_stack("destroy_signal");
   _slgtk_debug = 0;
   gtk_main_quit ();
} % }}}

define delete_event (widget, event, data ){ return FALSE; }

define reload_tests(button_ignored) % {{{
{
   variable test, status;
   foreach(tests) using ("values") {
	test = ();
	if (test.func != unsupported_ref) {
	   status = evalfile(test.name + ".sl");
	   if (status != 1)
		vmessage("WARNING: evalfile(" + test.name + ".sl) returned %S",
									status);
	}
   }
} % }}}

define struct2string(s) % {{{
{
   variable name, value, str = "";

   foreach (get_struct_field_names(s)) {
	name = ();
	value = get_struct_field (s, name);
	str = sprintf("%s\n\%s\t\t= %S",str,name,value);
   }
   return str;
} % }}}

define validate_opaque_ref_handling() % {{{
{
   variable win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   if (win == NULL)
      error("Could not allocate window widget");
   () = g_signal_connect(win, "destroy", &gtk_widget_destroyed, &win);
   gtk_widget_destroy(win);
   if (win != NULL)
      error("Regression failure: window not NULLed by gtk_widget_destroyed()");
} % }}}

provide("demoutils");
