
private variable window = NULL,
	plugged,
	plug = getenv("SLGTK_DIST_DIR");

if (plug == NULL)
   plug = "..";
plug += "/examples/gtkplug";

private define plug_added(socket_widget) % {{{
{
   vmessage("parent: GtkPlug added to my GtkSocket ...");
   plugged = 1;
} % }}}

private define plug_removed(socket_widget, test) % {{{
{
   vmessage("parent: GtkPlug removed from my GtkSocket ...");
   plugged = 0;
   g_signal_emit_by_name(test.lower, "clicked");
   return FALSE;
} % }}}

private define safe_terminate(window) % {{{
{
   if (not plugged) {
	gtk_widget_destroy(window);
	return;
   }
   vmessage("parent: you must press the GtkPlug button first!");
} % }}}

private define prevent_unsafe_terminate(window, event)
{
   safe_terminate(window);
   return TRUE;
}

public define create_socket(test) % {{{
{
   if (window != NULL) 
	return;

   plugged = 0;
   
   variable socket = gtk_socket_new();
   () = g_signal_connect(socket, "plug-added", &plug_added);
   () = g_signal_connect(socket, "plug-removed", &plug_removed, test);

   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   () = g_signal_connect(window,"delete-event", &prevent_unsafe_terminate);
   () = g_signal_connect(window,"destroy", &gtk_widget_destroyed, &window);

   variable vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_add(window, vbox);
   gtk_container_add(vbox, socket);

   test.lower = generic_close_button(vbox, window, &safe_terminate);
   gtk_widget_show_all(window);

   () = system( sprintf("$plug %S &"$, gtk_socket_get_id(socket)) );
} % }}}
