
% NB: writing of color images with transparency is tested in reflect.sl

setup;

written = "write.gif";
() = remove(written);

% Test 1: greyscale image
im = gif_normalize([1:200*300]);
reshape(im, [200,300]);
gif_write(written, im);
compare(im, gif_read(written));
grey = im;

% Test 2: color image
dims = [140, 107, 3];
nelems = int(prod(dims));
nbytes = fread(&im, UChar_Type, nelems, fopen("logo.bin", "rb"));
if(nbytes != nelems)
   error("Could not read $nelem bytes from $file, only $nbytes were read"$);

reshape(im, dims);
gif_write(written, im);
compare(im, gif_read(written));

% Test 3: write to an opened file descriptor
() = remove(written);
fd = open(written, O_WRONLY |  O_BINARY | O_CREAT, S_IRWXU);
gif_write(fd, im);
close(fd);
compare(im, gif_read(written));

% Test 4: image with odd w/h dimensions
im = gif_normalize([1:25109]);
reshape(im, [119,211]);
gif_write(written, im);
compare(im, gif_read(written));

% Test 5: write to read-only file (should fail)
() = chmod(written, 0);
Fail(&gif_write, written, grey);

% Test 6:  image with >3 dimensions (should fail)
im4d = UChar_Type[5,10,20,50];
Fail(&gif_write, written, im4d);

% Test 7:  write 1D image of length N (will come back as 2D, with dims [N,1])
() = remove(written);
im =  typecast([1:200*200], UChar_Type);
gif_write(written, im);
compare(_reshape(im, [200*200,1]), gif_read(written));

% Test 8:  attempt to output set of images, but 1 or more invalid (e.g. 4D)
l = {im, im, im4d, im};
Fail(&gif_write, written, l);

%() = remove(written);
