#ifndef __vtkSlicerCacheAndDataIOManagerGUI_h
#define __vtkSlicerCacheAndDataIOManagerGUI_h

#include "vtkSlicerBaseGUIWin32Header.h"
#include "vtkSlicerComponentGUI.h"
#include "vtkCacheManager.h"
#include "vtkSlicerFoundationIcons.h"

#include "vtkObserverManager.h"
#include "vtkMRMLScene.h"
#include "vtkMRMLNode.h"
#include "vtkDataIOManager.h"
#include "vtkCollection.h"

#include "vtkKWFrame.h"
#include "vtkKWPushButton.h"
#include "vtkKWCheckButton.h"
#include "vtkKWLabel.h"
#include "vtkKWTopLevel.h"
#include "vtkKWFrameWithScrollbar.h"
#include "vtkKWSpinBox.h"
#include "vtkKWSpinBoxWithLabel.h"
#include "vtkKWLoadSaveButton.h"
#include "vtkKWLoadSaveButtonWithLabel.h"

class VTK_SLICER_BASE_GUI_EXPORT vtkSlicerCacheAndDataIOManagerGUI : public vtkSlicerComponentGUI
{
public:
  ///  
  /// Usual vtk class functions 
  static vtkSlicerCacheAndDataIOManagerGUI* New (  );
  vtkTypeRevisionMacro ( vtkSlicerCacheAndDataIOManagerGUI, vtkSlicerComponentGUI );
  void PrintSelf ( ostream& os, vtkIndent indent );

  /// 
  /// tracks all data transfers in and out of scene
  vtkGetObjectMacro ( DataIOManager, vtkDataIOManager );

  /// 
  /// tracks cache
  vtkGetObjectMacro ( CacheManager, vtkCacheManager );
  vtkGetObjectMacro ( CacheSizeLabel, vtkKWLabel );
  vtkGetObjectMacro ( CacheFreeLabel, vtkKWLabel );
  vtkGetObjectMacro ( CloseButton, vtkKWPushButton );
  vtkGetObjectMacro ( ClearCacheButton, vtkKWPushButton );
  vtkGetObjectMacro ( ClearDisplayButton, vtkKWPushButton );
  vtkGetObjectMacro ( CancelAllButton, vtkKWPushButton );
  vtkGetObjectMacro ( RefreshButton, vtkKWPushButton );
  vtkGetObjectMacro ( ForceReloadCheckButton, vtkKWCheckButton );
  vtkGetObjectMacro ( OverwriteCacheCheckButton, vtkKWCheckButton );
  vtkGetObjectMacro ( AsynchronousCheckButton, vtkKWCheckButton );
  vtkGetObjectMacro ( CacheDirectoryButton, vtkKWLoadSaveButtonWithLabel );
  vtkGetObjectMacro ( CacheLimitSpinBox, vtkKWSpinBoxWithLabel );
  vtkGetObjectMacro ( CacheFreeBufferSizeSpinBox, vtkKWSpinBoxWithLabel );
  vtkGetObjectMacro ( TimeOutCheckButton, vtkKWCheckButton );
  vtkGetObjectMacro ( ManagerTopLevel, vtkKWTopLevel );
  vtkGetObjectMacro ( ControlFrame, vtkKWFrame );
  vtkGetObjectMacro ( ButtonFrame, vtkKWFrame );
  vtkGetObjectMacro ( TransfersFrame, vtkKWFrameWithScrollbar );
  vtkSetMacro ( Built, bool );
  vtkGetMacro ( Built, bool );
  vtkGetObjectMacro ( TransferWidgetCollection, vtkCollection );

  /// 
  /// This method builds the DataIOManager module GUI
  virtual void BuildGUI ( void );
  virtual void BuildGUI ( vtkKWFrame * f ) { this->Superclass::BuildGUI(f); }
  virtual void BuildGUI ( vtkKWFrame * f, double * bgColor ) { this->Superclass::BuildGUI(f,bgColor); }

  /// 
  /// This method releases references and key-bindings,
  /// and optionally removes observers.
  virtual void TearDownGUI ( );

  /// 
  /// Methods for adding module-specific key bindings and
  /// removing them.
  virtual void CreateModuleEventBindings ( );
  virtual void ReleaseModuleEventBindings ( );

  /// 
  /// Add/Remove observers on widgets in the GUI
  virtual void AddGUIObservers ( );
  virtual void RemoveGUIObservers ( );

  /// 
  /// Class's mediator methods for processing events invoked by
  /// either the Logic, MRML or GUI.
  virtual void ProcessLogicEvents ( vtkObject *caller, unsigned long event, void *callData );
  virtual void ProcessGUIEvents ( vtkObject *caller, unsigned long event, void *callData );
  virtual void ProcessMRMLEvents ( vtkObject *caller, unsigned long event, void *callData );


  /// 
  /// Methods describe behavior at module enter and exit.
  virtual void Enter ( );
  virtual void Enter ( vtkMRMLNode* node ) { this->Superclass::Enter(node); }
  virtual void Exit ( );

  /// 
  /// Update the gui from the currently selected DataIOManager node, called on Enter
  void UpdateEntireGUI();
  void UpdateOverviewPanel();
  void UpdateTransfersPanel();

  /// 
  /// API for setting DataIOManager, and for
  /// setting and observing it.
  void SetDataIOManager ( vtkDataIOManager *iomanager);
  void SetAndObserveDataIOManager ( vtkDataIOManager *iomanager);

  /// 
  /// API for setting CacheManager, and for
  /// setting and observing it.
  void SetCacheManager ( vtkCacheManager *cmanager);
  void SetAndObserveCacheManager ( vtkCacheManager *cmanager );
  
  /// 
  /// Creates a data transfer widget to represent a transfer.
  void AddNewDataTransfer ( vtkDataTransfer *transfer );
  void DeleteDataTransfer ( vtkDataTransfer *transfer );
  void DeleteDataTransfer ( int ID );
  void CancelAllDataTransfers();

  /// 
  /// Methods for displaying and hiding the Cache and DataIO Manager
  /// Internal callbacks; do not use.
  virtual void DisplayManagerWindow ( );
  virtual void WithdrawManagerWindow ( );

  void RemoteCacheDirectoryCallback();
  
protected:
  vtkSlicerCacheAndDataIOManagerGUI ( );
  virtual ~vtkSlicerCacheAndDataIOManagerGUI ( );

  /// Widgets for the DataIOManager module
  /// add a point
  vtkKWLabel *CacheSizeLabel;
  vtkKWLabel *CacheFreeLabel;
  vtkKWPushButton *CloseButton;
  vtkKWPushButton *ClearCacheButton;
  vtkKWPushButton *CancelAllButton;
  vtkKWPushButton *RefreshButton;
  vtkKWPushButton *ClearDisplayButton;
  vtkKWCheckButton *ForceReloadCheckButton;
  vtkKWCheckButton *OverwriteCacheCheckButton;
  vtkKWCheckButton *AsynchronousCheckButton;
  vtkKWCheckButton *TimeOutCheckButton;
  vtkKWTopLevel *ManagerTopLevel;
  vtkKWFrame *ControlFrame;
  vtkKWFrame *ButtonFrame;
  vtkKWFrameWithScrollbar *TransfersFrame;
  
  vtkDataIOManager *DataIOManager;
  vtkCacheManager *CacheManager;
  vtkCollection *TransferWidgetCollection;

  vtkKWLoadSaveButtonWithLabel *CacheDirectoryButton;
  vtkKWSpinBoxWithLabel *CacheLimitSpinBox;
  vtkKWSpinBoxWithLabel *CacheFreeBufferSizeSpinBox;
  
  /// 
  /// Describes whether the GUI has been built or not.
  bool Built;

private:
  vtkSlicerCacheAndDataIOManagerGUI ( const vtkSlicerCacheAndDataIOManagerGUI& ); /// Not implemented.
  void operator = ( const vtkSlicerCacheAndDataIOManagerGUI& ); //Not implemented.
};
#endif
