#ifndef __vtkIntegratedNavigationGUI_h
#define __vtkIntegratedNavigationGUI_h

#include "vtkSlicerModuleGUI.h"
#include "vtkIntegratedNavigation.h"

class vtkIntegratedNavigationLogic;
class vtkIntegratedNavigationMRMLManager;
class vtkIntegratedNavigationLoadingDataStep;
class vtkIntegratedNavigationUserInputStep;
class vtkMRMLNode;
class vtkKWWizardWidget;
 
class VTK_IGT_EXPORT vtkIntegratedNavigationGUI : public vtkSlicerModuleGUI
{
public:
  static vtkIntegratedNavigationGUI *New();
  vtkTypeMacro(vtkIntegratedNavigationGUI,vtkSlicerModuleGUI);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description: 
  // Get the categorization of the module.
  const char *GetCategory() const { return "IGT"; }

  // Description: 
  // Get/Set logic node
  vtkGetObjectMacro(Logic, vtkIntegratedNavigationLogic);
//  virtual void SetLogic(vtkIntegratedNavigationLogic*);

  /// Implement setter for vtkLogic* pointer
//  virtual void SetModuleLogic(vtkSlicerLogic*);
  void SetModuleLogic ( vtkSlicerLogic *logic );
 
  // Get/Set mrml manager node
  vtkGetObjectMacro(MRMLManager, vtkIntegratedNavigationMRMLManager);
  virtual void SetMRMLManager(vtkIntegratedNavigationMRMLManager*);

  // Description: 
  // Get/Set MRML node
  vtkGetObjectMacro(Node, vtkMRMLNode);
  virtual void SetNode(vtkMRMLNode*);

  // Description:
  // Create widgets
  virtual void BuildGUI();

  // Description:
  // Initialize module
  virtual void Init();

  // Description:
  // Delete Widgets
  virtual void TearDownGUI();

  // Description:
  // Add observers to GUI widgets
  virtual void AddGUIObservers();
  
  // Description:
  // Remove observers to GUI widgets
  //virtual void RemoveGUIObservers();

  // Description:
  // Remove observers to MRML node
  //virtual void RemoveMRMLNodeObservers();

  // Description:
  // Remove observers to Logic
  virtual void RemoveLogicObservers();
  
  // Description:
  // Pprocess events generated by Logic
  virtual void ProcessLogicEvents( vtkObject *caller, unsigned long event,
                                   void *callData); 

  // Description:
  // Pprocess events generated by GUI widgets
  /*virtual void ProcessGUIEvents( vtkObject *caller, unsigned long event,
                                 void *callData); */
  // Description:
  // Process events generated by MRML
  virtual void ProcessMRMLEvents( vtkObject *caller, unsigned long event, 
                                  void *callData);

  // Description:
  // Describe behavior at module startup and exit.
  virtual void Enter() { };
  virtual void Exit() { };

  // Description: The name of the Module - this is used to 
  // construct the proc invocations
  vtkGetStringMacro(ModuleName);
  vtkSetStringMacro(ModuleName);

 // Description: 
  // Get wizard widget
  vtkGetObjectMacro(WizardWidget, vtkKWWizardWidget);

  // Description: set an observer by number (work around
  // limitation in kwwidgets tcl wrapping)
  unsigned long AddObserverByNumber(vtkObject *observee, unsigned long event);

protected:
  vtkIntegratedNavigationGUI();
  ~vtkIntegratedNavigationGUI();
  vtkIntegratedNavigationGUI(const vtkIntegratedNavigationGUI&);
  void operator=(const vtkIntegratedNavigationGUI&);

  // Description:
  // Updates GUI widgets based on parameters values in MRML node
  void UpdateGUI();

  // Description:
  // Updates parameters values in MRML node based on GUI widgets 
  void UpdateMRML();
  
  vtkIntegratedNavigationLogic       *Logic;
  vtkIntegratedNavigationMRMLManager *MRMLManager;
  vtkMRMLNode       *Node;
  
  char *ModuleName;

  // Description:
  // The wizard widget and steps
  vtkIntegratedNavigationLoadingDataStep      *LoadingDataStep;
  vtkIntegratedNavigationUserInputStep        *UserInputStep; 
  vtkKWWizardWidget                           *WizardWidget;

};

#endif
