"""Add source and legacy ID for archived messages

Revision ID: b64b1a793483
Revises: 82a4af84b679
Create Date: 2024-07-22 21:06:35.020569

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

from slidge.db.models import ArchivedMessage

# revision identifiers, used by Alembic.
revision: str = "b64b1a793483"
down_revision: Union[str, None] = "82a4af84b679"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # since we don't want source to be nullable, we drop all rows first.
    # This is what you get by using alpha versions!
    op.execute(sa.delete(ArchivedMessage))
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("mam", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "source",
                sa.Enum("LIVE", "BACKFILL", name="archivedmessagesource"),
                nullable=False,
            )
        )
        batch_op.add_column(sa.Column("legacy_id", sa.String(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("mam", schema=None) as batch_op:
        batch_op.drop_column("legacy_id")
        batch_op.drop_column("source")

    # ### end Alembic commands ###
