%{

/* jsp_count by Bob Brown (http://www.openeye.com/rlb) tweaks from
   pascal_count.l by David A. Wheeler (http://www.dwheeler.com).
   Licensed under the GNU GPL, version 2.

*/

#include "driver.h"

#define YY_NO_UNPUT

/* 1 if we saw a non-comment, non-whitespace char on this line */
int saw_char = 0;
static void count(void);

%}

%option noyywrap

SPACE		[ \t\n\r\f]

%x chtml
%x cjsp
%x string

%%
	line_number = 1;
	saw_char = 0;
	BEGIN(INITIAL);

[ \t\r\f]	/* Do nothing */
"<!--"	{ BEGIN(chtml); }
"<%--"	{ BEGIN(cjsp); }
\n	{ count(); }

\"	{saw_char = 1; BEGIN(string);}

[^ \t\r\f(\n<"][^<\n"]*	{saw_char = 1;}
.	{saw_char = 1;}


<chtml>"-->"     { BEGIN(INITIAL); }
<chtml>\n	 { count(); }
<chtml>.	 /* no-op */

<cjsp>"--%>"	 { BEGIN(INITIAL); }
<cjsp>\n	 { count(); }
<cjsp>.		 /* no-op */

<string>[^\"\n]+ {saw_char = 1;}
<string>\n	 {
		 	fprintf(stderr, "Warning: newline in string - file %s, line %ld\n",
	                 filename, line_number);
			count();
			BEGIN(INITIAL); /* Switch back; this at least limits damage */
		 }
<string>\"		{ BEGIN(INITIAL);}

%%

#include "driver.c"

static void count(void)
{
    if ( saw_char ) {
        sloc++;
	saw_char = 0;
    }
    line_number++;
}
