#include <stdint.h>

#include "allfiles.h"
#include "errors.h"
#include "moreio.h"
#include "version.h"
#include "sludger.h"
#include "colours.h"
#include "backdrop.h"
#include "graphics.h"
#include "newfatal.h"

bool freeze ();
void unfreeze (bool);	// Because FREEZE.H needs a load of other includes

int thumbWidth = 0, thumbHeight = 0;

extern GLuint backdropTextureName;


bool saveThumbnail (FILE * fp) {
	GLuint thumbnailTextureName = 0;

	put4bytes (thumbWidth, fp);
	put4bytes (thumbHeight, fp);

	if (thumbWidth && thumbHeight) {
		if (! freeze ()) return false;


		glEnable (GL_TEXTURE_2D);
		setPixelCoords (true);
		glUseProgram(0);

		glGenTextures (1, &thumbnailTextureName);
		glBindTexture(GL_TEXTURE_2D, thumbnailTextureName);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, thumbWidth, thumbHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);

		// Render the backdrop (scaled)
		glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture (GL_TEXTURE_2D, backdropTextureName);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

		const GLint vertices[] = { 
			0, 0, 0, 
			thumbWidth-1, 0, 0, 
			thumbWidth-1, thumbHeight-1, 0, 
			0, thumbHeight-1, 0
		};

		const GLfloat texCoords[] = { 
			0.0f, 0.0f,
			backdropTexW, 0.0f,
			backdropTexW, backdropTexH, 
			0.0f, backdropTexH
		}; 

		glEnableClientState(GL_VERTEX_ARRAY);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);

		glVertexPointer(3, GL_INT, 0, vertices);
		glTexCoordPointer(2, GL_FLOAT, 0, texCoords);

		glDrawArrays(GL_QUADS, 0, 4);

		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		glDisableClientState(GL_VERTEX_ARRAY);

		if (gameSettings.antiAlias < 0) {
			glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		} else {
			glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		}
		glDeleteTextures (1, &thumbnailTextureName);
		thumbnailTextureName = 0;
		
		// Save Our ViewPort
		GLushort* image = new GLushort [thumbWidth*thumbHeight];
		glReadPixels(viewportOffsetX, viewportOffsetY, thumbWidth, thumbHeight, GL_RGB, GL_UNSIGNED_SHORT_5_6_5, image);

		setPixelCoords (false);

		for (int y = 0; y < thumbHeight; y ++) {
			for (int x = 0; x < thumbWidth; x ++) {
				put2bytes ((*(image +y*thumbWidth+x)), fp);
			}
		}
		delete image;
		image = NULL;
		unfreeze (true);
	}
	fputc ('!', fp);
	return true;
}

void showThumbnail (char * filename, int atX, int atY) {
	GLubyte * thumbnailTexture = NULL;
	GLuint thumbnailTextureName = 0;

	int ssgVersion;
	FILE * fp = openAndVerify (filename, 'S', 'A', ERROR_GAME_LOAD_NO, ssgVersion);
	if (ssgVersion >= VERSION(1,4)) {
		if (fp == NULL) return;
		int fileWidth = get4bytes (fp);
		int fileHeight = get4bytes (fp);

		int picWidth = fileWidth;
		int picHeight = fileHeight;
		if (! NPOT_textures) {
			picWidth = getNextPOT(picWidth);
			picHeight = getNextPOT(picHeight);
		}

		thumbnailTexture = new GLubyte [picHeight*picWidth*4];
		if (thumbnailTexture == NULL) return;

		int t1, t2;
		unsigned short c;
		GLubyte * target;
		for (t2 = 0; t2 < fileHeight; t2 ++) {
			t1 = 0;
			while (t1 < fileWidth) {
				c = (unsigned short) get2bytes (fp);
				target = thumbnailTexture + 4*picWidth*t2 + t1*4;
				target[0] = (GLubyte) redValue(c);
				target[1] = (GLubyte) greenValue(c);
				target[2] = (GLubyte) blueValue(c);
				target[3] = (GLubyte) 255;
				t1++;
			}
		}

		fclose (fp);

		glGenTextures (1, &thumbnailTextureName);
		glBindTexture(GL_TEXTURE_2D, thumbnailTextureName);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, picWidth, picHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, thumbnailTexture);

		delete thumbnailTexture;
		thumbnailTexture = NULL;

		if (atX<0){
			fileWidth+= atX;
			atX=0;
		}
		if (atY<0){
			fileHeight+= atY;
			atY=0;
		}
		if (fileWidth + atX > sceneWidth) fileWidth = sceneWidth-atX;
		if (fileHeight + atY > sceneHeight) fileHeight = sceneHeight-atY;

		glEnable (GL_TEXTURE_2D);
		setPixelCoords (true);
		int xoffset = 0;
		while (xoffset < fileWidth) {
			int w = (fileWidth-xoffset < viewportWidth) ? fileWidth-xoffset : viewportWidth;

			int yoffset = 0;
			while (yoffset < fileHeight) {
				int h = (fileHeight-yoffset < viewportHeight) ? fileHeight-yoffset : viewportHeight;

				glBindTexture (GL_TEXTURE_2D, thumbnailTextureName);

				const GLint vertices[] = { 
					fileWidth-1-xoffset, -yoffset, 0, 
					-xoffset, -yoffset, 0, 
					-xoffset, fileHeight-1-yoffset, 0, 
					fileWidth-1-xoffset, fileHeight-1-yoffset, 0
				};

				const GLfloat texCoords[] = { 
					backdropTexW, 0.0f,
					0.0f, 0.0f,
					0.0f, backdropTexH, 
					backdropTexW, backdropTexH
				}; 
	
				glEnableClientState(GL_VERTEX_ARRAY);
				glEnableClientState(GL_TEXTURE_COORD_ARRAY);

				glVertexPointer(3, GL_INT, 0, vertices);
				glTexCoordPointer(2, GL_FLOAT, 0, texCoords);

				glDrawArrays(GL_QUADS, 0, 4);

				glDisableClientState(GL_TEXTURE_COORD_ARRAY);
				glDisableClientState(GL_VERTEX_ARRAY);

				glDisable(GL_BLEND);

				// Copy Our ViewPort To The Texture
				glBindTexture(GL_TEXTURE_2D, backdropTextureName);
				glCopyTexSubImage2D(GL_TEXTURE_2D, 0, atX+xoffset, atY+yoffset, viewportOffsetX, viewportOffsetY, w, h);

				yoffset += viewportHeight;
			}
			xoffset += viewportWidth;
		}

		setPixelCoords (false);
		glDeleteTextures (1, &thumbnailTextureName);
		thumbnailTextureName = 0;
	}
}

bool skipThumbnail (FILE * fp) {
	thumbWidth = get4bytes (fp);
	thumbHeight = get4bytes (fp);
	uint32_t skippy = thumbWidth;
	skippy *= thumbHeight << 1;
	fseek (fp, skippy, 1);
	return (fgetc (fp) == '!');
}
