# Slune
# Copyright (C) 2002-2003 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import slune.globdef as globdef

def init         (*args): pass
def play_music   (*args): pass
def end_music    (): pass
def preload_sound(*args): pass
def play         (filename, position = None, speed = None, looping = 0, gain = 0): pass
def clean_mem    (*args): pass

if globdef.MUSIC or globdef.SOUND:
  print "* Slune * Using sound system %s" % globdef.SOUND_SYSTEM
  if   globdef.SOUND_SYSTEM == "OpenAL":
    import soya.openal4soya as sound4soya
    def clean_mem():
      sound4soya._CAMERA = None
      sound4soya._SOURCES_POS_SPEED *= 0
      
  elif globdef.SOUND_SYSTEM == "SDL_mixer":
    import soya.sdl_mixer4soya as sound4soya
    def clean_mem():
      sound4soya._CAMERA = None

  init          = sound4soya.init
  preload_sound = sound4soya.preload_sound
  
  if globdef.MUSIC:
    _MUSIC = None
    def play_music(filename):
      global _MUSIC
      if _MUSIC: _MUSIC.stop()
      _MUSIC = sound4soya.play(filename, None, None, 1, globdef.ASYNC_LOAD_MUSIC)
      
    def end_music ():
      global _MUSIC
      if _MUSIC:
        _MUSIC.stop()
        _MUSIC = None
    
  if globdef.SOUND:
    play = sound4soya.play

