/*
 * Given one or more node IDs as argument, present the corresponding node data.
 */
#include "basil_mysql.h"

int main(int ac, char **av)
{
	const char query[] =	"SELECT cab_position, cab_row, "
				"	cage, slot, cpu, "
				"	processor_type, "
				"	processor_status, "
				"	alloc_mode "
				"FROM  processor "
				"WHERE processor_id = ?";
	enum query_params {
			PAR_NID,
			PARAM_COUNT	/* sentinel */
	};
	MYSQL_BIND	bind_parm[PARAM_COUNT];
	unsigned int	node_id;

	enum query_columns {
			COL_CAB,
			COL_ROW,
			COL_CAGE,
			COL_SLOT,
			COL_CHIP,
			COL_TYPE,
			COL_STATE,
			COL_ALLOC,
			COLUMN_COUNT	/* sentinel */
	};
	MYSQL_BIND	bind_cols[COLUMN_COUNT];
	int		int_data[COL_CHIP + 1];
	char 		c_data[COL_ALLOC-COL_TYPE + 1][BASIL_STRING_SIZE];
	my_bool		is_null[COLUMN_COUNT];
	my_bool		error[COLUMN_COUNT];

	MYSQL		*handle;
	MYSQL_STMT	*stmt;
	int		rc = -1, i;

	handle = cray_connect_sdb();
	if (handle == NULL)
		errx(1, "can not connect to XTAdmin database on the SDB");

	/* Initialize bind structures for query and result parameters */
	memset(bind_parm, 0, sizeof(bind_parm));
	bind_parm[PAR_NID].buffer_type = MYSQL_TYPE_LONG;
	bind_parm[PAR_NID].buffer      = (char *)&node_id;
	bind_parm[PAR_NID].is_unsigned = true;

	memset(bind_cols, 0, sizeof(bind_cols));
	for (i = 0; i <= COL_CHIP; i++) {
		bind_cols[i].buffer_type = MYSQL_TYPE_LONG;
		bind_cols[i].buffer	 = (char *)&int_data[i];
		bind_cols[i].is_null	 = &is_null[i];
		bind_cols[i].error	 = &error[i];
	}
	for (i = COL_TYPE; i <= COL_ALLOC; i++) {
		bind_cols[i].buffer_type   = MYSQL_TYPE_STRING;
		bind_cols[i].buffer	   = c_data[i - COL_TYPE];
		bind_cols[i].buffer_length = BASIL_STRING_SIZE;
		bind_cols[i].is_null	   = &is_null[i];
		bind_cols[i].error	   = &error[i];
	}

	stmt = prepare_stmt(handle, query, bind_parm, PARAM_COUNT, 
					   bind_cols, COLUMN_COUNT);
	if (stmt == NULL)
		goto err;

	for (i = 0; --ac; i++) {
		if (sscanf(*++av, "%u", &node_id) != 1 &&
		    sscanf(*av, "nid%u", &node_id) != 1) {
			warnx("'%s' not in nid%%05d format", *av);
			continue;
		}

		if (!run_stmt(stmt, query, bind_cols, COLUMN_COUNT, true))
			goto err_close;

		if (i == 0)
			printf( "   NID    (HEX)    NODENAME     TYPE    STATUS        MODE\n");

		printf("%6u ", node_id);
		printf(node_id ? "%#8x" : "     0x%d", node_id);

		if (mysql_stmt_fetch(stmt) == 0) {
			printf("  c%d-%dc%ds%dn%d", int_data[COL_CAB],
				int_data[COL_ROW], int_data[COL_CAGE],
				int_data[COL_SLOT], int_data[COL_CHIP]);

			printf(" %8s %9s %11s\n", c_data[0],
				c_data[1], c_data[2]);
		} else {
			printf(" - NO RESULT\n");
		}
	}

	rc = 0;
err_close:
	if (mysql_stmt_close(stmt))
		warnx("error closing statement: %s",
			mysql_stmt_error(stmt));
err:
	mysql_close(handle);

	return rc ? EXIT_FAILURE : EXIT_SUCCESS;
}
