%define localstatedir   /var/lib

Summary:            sm-archive Sendmail Milter
Name:               sm-archive
Version:            1.7
Release:            1%{?dist}
License:            GPLv3+
Group:              System Environment/Daemons
Source:             http://www.five-ten-sg.com/%{name}/packages/%{name}-%{version}.tar.gz
BuildRoot:          %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
URL:                http://www.five-ten-sg.com/%{name}/

Requires(pre):          /usr/sbin/useradd
Requires(pre):          /usr/bin/getent
Requires(postun):       /usr/sbin/userdel
Requires(post,preun):   /sbin/chkconfig
Requires(post,preun):   /sbin/service
BuildRequires:          sendmail-devel >= 8.12.1
Requires:               sendmail >= 8.12.1
Requires:               sendmail-cf


%description
This milter adds recipient addresses to messages passing thru it, based
on a configuration file.

The sm-archive milter reads a text configuration file
(sm-archive.conf) on startup, and whenever the config file (or any of
the referenced include files) is changed. The entire configuration
file is case insensitive.


%prep
%setup -q


%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mv -f $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/%{name} $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/var/run/%{name}


%pre
/usr/bin/getent passwd sm-archive >/dev/null || useradd -r -d /etc/sm-archive -M -c "sm-archive pseudo-user" -s /sbin/nologin sm-archive >/dev/null


%post
/sbin/chkconfig --add %{name}
echo Remember to edit %{_sysconfdir}/%{name}/%{name}.conf and add the following line to your sendmail.mc:
echo "INPUT_MAIL_FILTER(\`sm-archive', \`S=local:/var/run/sm-archive/sm-archive.sock, F=T, T=C:30s;S:5m;R:5m;E:5m')"
echo


%preun
[ $1 = 0 ] && /sbin/service %{name} stop || :


%postun
[ $1 = 0 ] && /sbin/chkconfig --del %{name}
[ $1 = 0 ] && userdel %{name} || :


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%{_sbindir}/*
%{_mandir}/man1/*
%{_mandir}/man5/*
%docdir %{_datadir}/doc/%{name}-%{version}
%{_datadir}/doc/%{name}-%{version}
%config(noreplace) %attr(0750,%{name},root) %{_sysconfdir}/%{name}
/etc/rc.d/init.d/%{name}
%dir %attr(0750,%{name},root) /var/run/%{name}


%changelog
* Thu Jun 12 2008 Carl Byington <carl@five-ten-sg.com> - 1.7-1
- Fedora 9 compile and const correctness.

* Fri Mar 21 2008 Carl Byington <carl@five-ten-sg.com> - 1.6-1
- changes for Fedora packaging guidelines

* Fri Mar 10 2006 Carl Byington <carl@five-ten-sg.com> -1.0
- use autoconf and http://www.fedora.us/docs/rpm-packaging-guidelines.html
