/******************************************************************************
 * smartdimmer.c                                                              *
 *                                                                            *
 * SmartDimmer adjustment tool.                                               *
 * Thanks to Thunderbird and sk1p from #nvclock @ freenode for their help :)  *
 *                                                                            *
 * July 23, 2005                                                              *
 * Erik Waling <erikw@acc.umu.se>                                             *
 ******************************************************************************/

#define VERSION   0.1

/* SmartDimmer offset on nVIDIA Geforce Go 6200... probably other cards too. */
#define PMC_SMARTDIM_OFFSET     0x15f0
#define SMARTDIM_MASK           0x1f0000 /* 5 bits ==> 32 theoretical levels */
#define SMARTDIM_SHIFT          16

/*
 * The Windows driver allowed values between 4-21. Tried lower levels (down to
 * 1), and they seem to work just fine. Values above 21 has not been tested.
 */
#define MIN_LEVEL  1
#define MAX_LEVEL  21

/* for command line arguments */
#define SET_BIT    1
#define GET_BIT    2
#define INC_BIT    4
#define DEC_BIT    8

/* function prototypes */
void sd_set_level(int level);
int sd_get_level();
int sd_init();
void sd_usage();

