-- See the Copyright notice at the end of this file.
--
class XML_REPOSITORY_LAYOUT

insert
	INTERNALS_HANDLER

creation {XML_REPOSITORY_IMPL}
	make

feature {XML_REPOSITORY_IMPL, XML_REPOSITORY_LAYOUT}
	type: STRING

	capacity: INTEGER -- for native arrays only

	ref: STRING

	name: STRING

	value: STRING

	layouts: DICTIONARY[XML_REPOSITORY_LAYOUT, STRING]

	solve (a_solver: FUNCTION[TUPLE[STRING], INTERNALS]): INTERNALS is
		local
			i: INTEGER; layout: XML_REPOSITORY_LAYOUT; attribute_name: STRING; an_attribute: INTERNALS
			can_be_retrieved: BOOLEAN
		do
			Result := internals(a_solver)
			if Result /= Void then
				from
					can_be_retrieved := True
					i := 1
				until
					i > Result.type_attribute_count
				loop
					attribute_name := Result.type_attribute_name(i)
					if layouts.has(attribute_name) then
						layout := layouts.at(attribute_name)
						check
							layout.name.is_equal(attribute_name)
						end
						an_attribute := layout.solve(a_solver)
						if an_attribute /= Void and then not an_attribute.object_can_be_retrieved then
							can_be_retrieved := False
						end
					end
					i := i + 1
				end
				if can_be_retrieved then
					from
						i := 1
					until
						i > Result.type_attribute_count
					loop
						attribute_name := Result.type_attribute_name(i)
						if layouts.has(attribute_name) then
							layout := layouts.at(attribute_name)
							an_attribute := layout.solve(a_solver)
							if an_attribute /= Void then
								Result.set_object_attribute(an_attribute, i)
							end
						end
						i := i + 1
					end
					Result.set_object_can_be_retrieved
				else
					Result := Void
				end
			end
		end

	internals (a_solver: FUNCTION[TUPLE[STRING], INTERNALS]): INTERNALS is
			-- a_value is used for expanded attributes to directly set the object
		local
			c: CHARACTER; b: BOOLEAN; i: INTEGER; r: REAL; i8: INTEGER_8; i16: INTEGER_16; i32: INTEGER_32
			i64: INTEGER_64; r32: REAL_32; r64: REAL_64; r80: REAL_80; r128: REAL_128; re: REAL_EXTENDED
			array_type: STRING
		do
			inspect
				node
			when "layout" then
				Result := internals_from_generating_type(type)
			when "reference" then
				Result := a_solver.item([ref])
			when "embedded" then
				Result := internals_from_generating_type(type)
			when "array" then
				array_type := once ""
				array_type.copy(once "NATIVE_ARRAY[")
				array_type.append(type)
				array_type.extend(']')
				Result := native_array_internals_from_generating_type(array_type, capacity)
			when "basic" then
				inspect
					type
				when "CHARACTER" then
					c := value.to_integer.to_character
					Result := c.to_internals
				when "BOOLEAN" then
					b := value.is_equal("True")
					Result := b.to_internals
				when "INTEGER_8" then
					i8 := value.to_integer.to_integer_8
					Result := i8.to_internals
				when "INTEGER_16" then
					i16 := value.to_integer.to_integer_16
					Result := i16.to_internals
				when "INTEGER" then
					i := value.to_integer
					Result := i.to_internals
				when "INTEGER_32" then
					i32 := value.to_integer
					Result := i32.to_internals
				when "INTEGER_64" then
					i64 := value.to_integer_64
					Result := i64.to_internals
				when "REAL" then
					r := value.to_real
					Result := r.to_internals
				when "REAL_32" then
					r32 := value.to_real.force_to_real_32
					Result := r32.to_internals
				when "REAL_64" then
					r64 := value.to_real
					Result := r64.to_internals
				when "REAL_80" then
					r80 := value.to_real
					Result := r80.to_internals
				when "REAL_128" then
					r128 := value.to_real
					Result := r128.to_internals
				when "REAL_EXTENDED" then
					re := value.to_real
					Result := re.to_internals
				end
			end
		end

feature {XML_REPOSITORY_IMPL}
	node: STRING
			-- The XML node. I don't want to create 20 classes for such a simple thing.

	is_clear: BOOLEAN is
		do
			Result := node = Void
		end

	clear is
		do
			node := Void
			type := Void
			ref := Void
			name := Void
			value := Void
			layouts.clear_count
		ensure
			is_clear
		end

	set (a_node: like node) is
		require
			is_clear
		do
			node := node_memory
			node.copy(a_node)
		ensure
			not is_clear
			node.is_equal(a_node)
		end

	set_type (a_type: like type) is
		require
			not is_clear
			type = Void
			a_type /= Void
		do
			type := type_memory
			type.copy(a_type)
		ensure
			type.is_equal(a_type)
		end

	set_capacity (a_capacity: like capacity) is
		do
			capacity := a_capacity
		ensure
			capacity = a_capacity
		end

	set_ref (a_ref: like ref) is
		require
			not is_clear
			ref = Void
			a_ref /= Void
		do
			ref := ref_memory
			ref.copy(a_ref)
		ensure
			ref.is_equal(a_ref)
		end

	set_name (a_name: like name) is
		require
			not is_clear
			name = Void
			a_name /= Void
		do
			name := name_memory
			name.copy(a_name)
		ensure
			name.is_equal(a_name)
		end

	set_value (a_value: like value) is
		require
			not is_clear
			value = Void
			a_value /= Void
		do
			value := value_memory
			value.copy(a_value)
		ensure
			value.is_equal(a_value)
		end

	add_layout (a_layout: XML_REPOSITORY_LAYOUT) is
		require
			not is_clear
			a_layout.name /= Void
		do
			layouts.add(a_layout, a_layout.name)
		ensure
			layouts.at(a_layout.name) = a_layout
		end

feature {}
	make is
		do
			create {HASHED_DICTIONARY[XML_REPOSITORY_LAYOUT, STRING]} layouts.make
			node_memory := ""
			type_memory := ""
			ref_memory := ""
			name_memory := ""
			value_memory := ""
		ensure
			is_clear
		end

	node_memory: STRING

	type_memory: STRING

	ref_memory: STRING

	name_memory: STRING

	value_memory: STRING

end -- class XML_REPOSITORY_LAYOUT
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
