-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_AGENT64
	-- As for manifest TUPLE (test_agent63.e), a creation call must be
	-- captured and cannot hold open arguments.

insert
	EIFFELTEST_TOOLS

creation {ANY}
	make

feature {}
	loop_stack: LOOP_STACK

	make is
		do
			create loop_stack.make
			init(3)
			loop_stack.run
			assert(counter = 2)
		end

	init (repeat: INTEGER) is
		local
			update: SIMPLE_PERIODIC_JOB
		do
			create update.set_work(agent foo(create {STRING}.make(2)), Void, 1, 0.1)
			loop_stack.add_job(update)
			assert(counter = 0)
		end

	foo (repeat: STRING): BOOLEAN is
		do
			assert(repeat.count.in_range(0, 1))
			assert(repeat.capacity = 2)
			repeat.add_last(' ')
			counter := counter + 1
			Result := repeat.capacity > repeat.count
		end

	counter: INTEGER

end -- class TEST_AGENT64
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
