-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_ASSIGNMENT_TEST_AND_FORCE

insert
	EIFFELTEST_TOOLS

creation {ANY}
	make

feature {ANY}
	string: STRING

	animal: ANIMAL

	cat: CAT

	dog: DOG

	any: ANY

	array_integer: ARRAY[INTEGER]

	array_any: ARRAY[ANY]

	make is
		do
			-- Because `any' is Void:
			assert({STRING} ?:= any)
			any := "foo"
			assert(any /= Void)
			assert(string ?:= any)
			string ::= any
			assert(any = string)
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** assert(not cat ?:= any)
			-- *** INTEGER doesn't conform to ANY (Vincent Croizier, 02/11/2004) ***
			-- any := 3
			-- assert(not string ?:= any)
			-- string ?= any
			-- assert(string = Void)
			create cat
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** any := cat
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** assert(cat = any)
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** assert(not dog ?:= any)
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** assert(cat ?:= any)
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** cat ::= any
			-- *** Correctly rejected *** (Dom. nov 10th 2004) *** assert(cat = any)
			animal := cat
			assert(cat ?:= animal)
			cat ::= animal
			assert(cat = animal)
			animal := Void
			assert(cat ?:= animal)
			cat ::= animal
			assert(cat = Void)
		end

end -- class TEST_ASSIGNMENT_TEST_AND_FORCE
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
