-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_ENDIAN01

inherit
	EIFFELTEST_TOOLS

creation {ANY}
	make

feature {ANY}
	file_tools: FILE_TOOLS is
		once
			create Result
		end

	make is
		local
			bfw: BINARY_FILE_WRITE; bfr: BINARY_FILE_READ
		do
			create bfw.connect_to("test_endian01.dat")
			assert(bfw.is_connected)
			bfw.put_integer_16_native_endian(1)
			bfw.put_integer_16_native_endian(2)
			bfw.put_integer_16_native_endian(3)
			bfw.put_integer_16_native_endian(4)
			bfw.put_integer_16_big_endian(1)
			bfw.put_integer_16_big_endian(2)
			bfw.put_integer_16_big_endian(3)
			bfw.put_integer_16_big_endian(4)
			bfw.put_integer_16_little_endian(1)
			bfw.put_integer_16_little_endian(2)
			bfw.put_integer_16_little_endian(3)
			bfw.put_integer_16_little_endian(4)
			bfw.disconnect
			assert(not bfw.is_connected)
			create bfr.connect_to("test_endian01.dat")
			assert(bfr.is_connected)
			bfr.read_integer_16_native_endian
			assert(bfr.last_integer_16 = 1)
			bfr.read_integer_16_native_endian
			assert(bfr.last_integer_16 = 2)
			bfr.read_integer_16_native_endian
			assert(bfr.last_integer_16 = 3)
			bfr.read_integer_16_native_endian
			assert(bfr.last_integer_16 = 4)
			bfr.read_integer_16_big_endian
			assert(bfr.last_integer_16 = 1)
			bfr.read_integer_16_big_endian
			assert(bfr.last_integer_16 = 2)
			bfr.read_integer_16_big_endian
			assert(bfr.last_integer_16 = 3)
			bfr.read_integer_16_big_endian
			assert(bfr.last_integer_16 = 4)
			bfr.read_integer_16_little_endian
			assert(bfr.last_integer_16 = 1)
			bfr.read_integer_16_little_endian
			assert(bfr.last_integer_16 = 2)
			bfr.read_integer_16_little_endian
			assert(bfr.last_integer_16 = 3)
			bfr.read_integer_16_little_endian
			assert(bfr.last_integer_16 = 4)
			assert(not bfr.end_of_input)
			bfr.read_byte
			assert(bfr.end_of_input)
			bfr.disconnect
			assert(not bfr.is_connected)
			file_tools.delete("test_endian01.dat")
		end

end -- class TEST_ENDIAN01
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
