-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_NUMBER13
	-- tests on limits...

insert
	PLATFORM
	NUMBER_TOOLS

creation {ANY}
	make

feature {ANY}
	make is
		local
			n1, n2: NUMBER
		do
			-- to_integer
			n1 := from_integer(2)
			assert(n1.to_integer_32 = 2)
			n1 := n1 @- 2
			assert(n1.to_integer_32 = 0)
			n1 := n1 @- 1
			assert(n1.to_integer_32 = -1)
			-- maximum_integer & minimum_integer
			n1 := from_integer(Maximum_integer)
			assert(n1.to_integer_32 = Maximum_integer)
			n1 := n1 @+ 1
			assert(n1 @- 1 @= Maximum_integer)
			n2 := n1 @- 1
			assert(n2.to_integer_32 = Maximum_integer)
			n1 := from_integer(Minimum_integer)
			assert(n1.to_integer_32 = Minimum_integer)
			n1 := n1 @- 1
			assert(n1 @+ 1 @= Minimum_integer)
			n2 := n1 @+ 1
			assert(n2.to_integer_32 = Minimum_integer)
		end

	count: INTEGER

	assert (b: BOOLEAN) is
		do
			count := count + 1
			if not b then
				io.put_string("TEST_NUMBER13 : ERROR Test # ")
				io.put_integer(count)
				io.put_string("%N")
			end
		end

end -- class TEST_NUMBER13
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
