-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_NATIVE_ARRAY1

creation {ANY}
	make

feature {ANY}
	make is
		local
			a, b: NATIVE_ARRAY[CHARACTER]
		do
			a := a.calloc(2)
			a.put('a', 0)
			a.put('b', 1)
			assert(a.item(0) = 'a')
			assert(a.item(1) = 'b')
			a := a.realloc(2, 1024)
			assert(a.item(0) = 'a')
			assert(a.item(1) = 'b')
			b := b.calloc(2)
			assert(b.item(0) = '%/0/')
			assert(b.item(1) = '%U')
			b.put('a', 0)
			b.put('b', 1)
			assert(b.item(0) = 'a')
			assert(b.item(1) = 'b')
			b := b.realloc(2, 1024)
			assert(b.item(0) = 'a')
			assert(b.item(1) = 'b')
			assert(a.fast_memcmp(b, 2))
			assert(a.memcmp(b, 2))
		end

	assert (b: BOOLEAN) is
		do
			cpt := cpt + 1
			if not b then
				std_output.put_string("TEST_NATIVE_ARRAY1: ERROR Test # ")
				std_output.put_integer(cpt)
				std_output.put_string("%N")
			else
				-- std_output.put_string("Yes%N");
			end
		end

	cpt: INTEGER

end -- class TEST_NATIVE_ARRAY1
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
