expanded class CLASSES_TREE_FACTORY

insert
	GLOBALS

feature {ACE}
	universe: UNIVERSE is
		once
			create Result.make
		end

feature {CLASSES}
	classes (distance: INTEGER; system_path, path, name: STRING; loadpath: LOADPATH): CLASSES is
		require
			not name.is_empty
			string_aliaser.registered_one(name)
			not path.is_empty
			string_aliaser.registered_one(path)
			universe.classes_notation.is_absolute_path(path)
			;(create {FILE_TOOLS}).file_exists(system_path)
		do
			Result := classes_memory.reference_at(path)
			if Result = Void then
				if file_tools.is_directory(system_path) then
					if not universe.has_physical_cluster(system_path) then
						create {CLASSES_TREE} Result.make(distance, name, path, system_path)
					end
				else
					create {LOADPATH} Result.make(distance, name, path, system_path, loadpath)
				end
				classes_memory.add(Result, path)
			else
				error_handler.append(once "Classes path set more than once: ")
				error_handler.append(path)
				error_handler.print_as_warning --|*** Should be fatal error because it may mean cycle
			end
		end

feature {}
	file_tools: FILE_TOOLS

	classes_memory: DICTIONARY[CLASSES, STRING] is
		once
			create {HASHED_DICTIONARY[CLASSES, STRING]} Result.make
		end

end
