-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class E_OLD
	--
	-- To store the "old foo" expression that can be used only in ensure assertions.
	--

inherit
	EXPRESSION

creation {EIFFEL_PARSER}
	make

feature {ANY}
	start_position: POSITION
			-- Of the "old" keyword.

	expression: EXPRESSION
			-- The one after keyword "old".

	is_current: BOOLEAN is False

	is_implicit_current: BOOLEAN is False

	is_writable: BOOLEAN is False

	is_static: BOOLEAN is False

	is_manifest_string: BOOLEAN is False

	is_result: BOOLEAN is False

	is_void: BOOLEAN is False

	extra_bracket_flag: BOOLEAN is True

	safety_check (type: TYPE) is
		do
			expression.safety_check(type)
		end

	specialize_in (type: TYPE): like Current is
		local
			exp: like expression
		do
			if vaol_check_memory.item = Void then
				vaol_check_memory.set_item(Current)
			else
				error_handler.add_position(vaol_check_memory.item.start_position)
				error_handler.add_position(start_position)
				error_handler.append("Must not use old inside some old expression (VAOL.2).")
				error_handler.print_as_fatal_error
			end
			exp := expression.specialize_in(type)
			vaol_check_memory.clear
			Result := current_or_twin_init(exp)
		end

	specialize_thru (parent_type: TYPE; parent_edge: PARENT_EDGE; new_type: TYPE): like Current is
		local
			exp: like expression
		do
			exp := expression.specialize_thru(parent_type, parent_edge, new_type)
			Result := current_or_twin_init(exp)
		end

	specialize_2 (type: TYPE): like Current is
		local
			exp: like expression
		do
			exp := expression.specialize_2(type)
			Result := current_or_twin_init(exp)
		end

	side_effect_free (type: TYPE): BOOLEAN is
		do
			Result := True
		end

	has_been_specialized: BOOLEAN is
		do
			Result := expression.has_been_specialized
		end

	declaration_type: TYPE is
		do
			Result := expression.declaration_type
		end

	resolve_in (type: TYPE): TYPE is
		do
			Result := expression.resolve_in(type)
		end

	non_void_no_dispatch_type (type: TYPE): TYPE is
		do
			--|*** To be done. *** (Dom. june 18th 2004) ***
		end

	simplify (type: TYPE): EXPRESSION is
		do
			check
				False -- Because `simplify' is only made for -boost.
			end
		end

	bracketed_pretty (indent_level: INTEGER) is
		do
			pretty_printer.put_character('(')
			pretty(indent_level)
			pretty_printer.put_character(')')
		end

	pretty (indent_level: INTEGER) is
		do
			pretty_printer.keyword(once "old")
			if expression.precedence <= precedence then
				expression.bracketed_pretty(indent_level + 1)
			else
				expression.pretty(indent_level + 1)
			end
		end

	pretty_target (indent_level: INTEGER) is
		do
			pretty_printer.put_character('(')
			pretty(indent_level)
			pretty_printer.put_character(')')
			pretty_printer.put_character('.')
		end

	short (type: TYPE) is
		do
			short_printer.hook_or(once "old", once "old ")
			expression.short(type)
		end

	short_target (type: TYPE) is
		do
			bracketed_short(type)
			short_printer.put_dot
		end

	precedence: INTEGER is
		do
			Result := 11
		end

	compile_to_c_old (type: TYPE) is
		do
			cpp.pending_c_function_body.append(local_c_name)
			cpp.pending_c_function_body.extend('=')
			expression.mapping_c_arg(type)
			cpp.pending_c_function_body.append(once ";%N")
		end

	compile_to_c (type: TYPE) is
		do
			cpp.pending_c_function_body.append(local_c_name)
		end

	mapping_c_target (type, formal_target_type: TYPE) is
		do
			standard_mapping_c_target(type, formal_target_type)
		end

	mapping_c_arg (type: TYPE) is
		do
			compile_to_c(type)
		end

	compile_to_jvm_old (type: TYPE) is
		local
			e: like expression; rt: TYPE_MARK
		do
			e := expression
			rt := e.resolve_in(type).canonical_type_mark
			id := code_attribute.extra_local(rt)
			e.compile_to_jvm(type)
			rt.jvm_write_local_creation(id)
		end

	compile_to_jvm (type: TYPE) is
		do
			expression.resolve_in(type).canonical_type_mark.jvm_push_local(id)
		end

	compile_target_to_jvm (type: TYPE) is
		do
			standard_compile_target_to_jvm(type)
		end

	jvm_branch_if_false (type: TYPE): INTEGER is
		do
			Result := jvm_standard_branch_if_false(type)
		end

	jvm_branch_if_true (type: TYPE): INTEGER is
		do
			Result := jvm_standard_branch_if_true(type)
		end

	jvm_assign_creation, jvm_assign (type: TYPE) is
		do
			check
				False
			end
		end

	use_current (type: TYPE): BOOLEAN is
		do
			Result := expression.use_current(type)
		end

	collect (type: TYPE): TYPE is
		do
			Result := expression.collect(type)
		end

	adapt_for (type: TYPE): like Current is
		do
			Result := current_or_twin_init(expression.adapt_for(type))
			smart_eiffel.register_old(Result)
		end

	accept (visitor: E_OLD_VISITOR) is
		do
			visitor.visit_e_old(Current)
		end

feature {RUN_FEATURE}
	c_declare_for_old (type: TYPE) is
		local
			result_type: TYPE_MARK; name, c_frame_descriptor_format, c_frame_descriptor_locals: STRING
			p: POSITION
		do
			name := local_c_name
			result_type := resolve_in(type).canonical_type_mark
			result_type.c_type_for_argument_in(cpp.pending_c_function_body)
			cpp.pending_c_function_body.extend(' ')
			cpp.pending_c_function_body.append(name)
			cpp.pending_c_function_body.extend('=')
			result_type.c_initialize_in(cpp.pending_c_function_body)
			cpp.pending_c_function_body.append(once ";%N")
			-- Now updating the `c_frame_descriptor':
			c_frame_descriptor_locals := cpp.c_frame_descriptor_locals
			c_frame_descriptor_locals.append(once "(void**)&")
			c_frame_descriptor_locals.append(name)
			c_frame_descriptor_locals.extend(',')
			p := start_position
			c_frame_descriptor_format := cpp.c_frame_descriptor_format
			c_frame_descriptor_format.append(once "old value")
			result_type.c_frame_descriptor_in(c_frame_descriptor_format)
		end

feature {RUN_FEATURE}
	local_c_name: STRING is
		local
			suffix: INTEGER; string_buffer: STRING
		do
			if local_c_name_memory = Void then
				string_buffer := once "......... unique buffer ............."
				string_buffer.clear_count
				string_buffer.extend('o')
				start_position.class_text.id.append_in(string_buffer)
				string_buffer.extend('_')
				start_position.line.append_in(string_buffer)
				string_buffer.extend('_')
				suffix := start_position.column
				if suffix = 0 then
					special_old_counter.increment
					suffix := special_old_counter.value
					string_buffer.extend('s')
				end
				suffix.append_in(string_buffer)
				local_c_name_memory := string_buffer.twin
			end
			Result := local_c_name_memory
		end

feature {E_OLD}
	init (exp: like expression) is
		require
			exp /= Void
		do
			expression := exp
		ensure
			expression = exp
		end

feature {}
	local_c_name_memory: STRING
			-- The C name for the local variable.

	id: INTEGER
			-- Used in Java byte code to gives a number to the the extra local variable.

	make (sp: like start_position; exp: like expression) is
		require
			not sp.is_unknown
			exp /= Void
		do
			start_position := sp
			expression := exp
		ensure
			start_position = sp
			expression = exp
		end

	current_or_twin_init (exp: like expression): like Current is
		require
			exp /= Void
		do
			if exp = expression then
				Result := Current
			else
				Result := twin
				Result.init(exp)
			end
		ensure
			Result.expression = exp
		end

	special_old_counter: COUNTER is
			-- This counter is only used to provide unique name for old expression where column is unknown.
		once
			create Result
		end

	vaol_check_memory: REFERENCE[E_OLD] is
		once
			create Result
		end

invariant
	expression /= Void

end -- class E_OLD
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
