-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
deferred class E_ROUTINE
	--
	-- Root class for all sort of routines : function, procedure,
	-- external function/procedure, deferred function/procedure and
	-- once function/procedure.
	--
	--

inherit
	ANONYMOUS_FEATURE
		redefine
			set_end_comment
		end

feature {ANY}
	arguments: FORMAL_ARG_LIST

	obsolete_mark: MANIFEST_STRING

	end_comment: COMMENT

	is_attribute: BOOLEAN is False

	local_vars: LOCAL_VAR_LIST

	internal_locals: INTERNAL_LOCAL_LIST

	routine_body: INSTRUCTION

	pretty is
		local
			fn: FEATURE_NAME; il: INTEGER
		do
			pretty_print_names
			if arguments /= Void then
				if not pretty_printer.zen_mode then
					pretty_printer.put_character(' ')
				end
				arguments.pretty
			end
			if result_type /= Void then
				pretty_printer.put_character(':')
				if not pretty_printer.zen_mode then
					pretty_printer.put_character(' ')
				end
				pretty_printer.put_type_mark(result_type)
			end
			pretty_printer.keyword(once "is")
			pretty_printer.set_indent_level(2)
			if header_comment /= Void then
				il := pretty_printer.indent_level_for_header_comment_of_feature
				pretty_printer.set_indent_level(il)
				header_comment.pretty(il)
			end
			pretty_printer.set_indent_level(2)
			if obsolete_mark /= Void then
				pretty_printer.keyword(once "obsolete")
				obsolete_mark.pretty_without_once(2)
			end
			pretty_printer.set_indent_level(2)
			if require_assertion /= Void then
				require_assertion.pretty_print
			end
			pretty_printer.set_indent_level(3)
			pretty_print_routine_body
			if ensure_assertion /= Void then
				pretty_printer.set_indent_level(2)
				ensure_assertion.pretty_print
			end
			pretty_print_rescue
			pretty_printer.set_indent_level(2)
			pretty_printer.keyword(once "end")
			if end_comment /= Void and then not end_comment.is_dummy_feature_end(Current) then
				end_comment.pretty(2)
			elseif pretty_printer.print_end_of_feature then
				pretty_printer.put_string(once "-- ")
				fn := first_name
				fn.inside_end_comment_pretty_print
			end
			pretty_printer.set_indent_level(0)
		end

feature {EIFFEL_PARSER}
	set_end_comment (ec: like end_comment) is
		require else
			end_comment = Void
			ec /= Void
		do
			end_comment := ec
		ensure
			end_comment = ec
		end

feature {FEATURE_TEXT, EIFFEL_PARSER}
	set_ensure_assertion (ea: like ensure_assertion) is
		do
			ensure_assertion := ea
		end

	set_rescue_compound (rc: like rescue_compound) is
		deferred
		end

feature {ANONYMOUS_FEATURE_MIXER}
	specialize_signature_in (new_type: TYPE): like Current is
		local
			args: like arguments
		do
			if arguments /= Void then
				args := arguments.specialize_in(new_type)
			end
			if args = arguments then
				Result := Current
			else
				Result := twin
				Result.set_arguments(args)
			end
		end

	specialize_signature_thru (parent_type: TYPE; parent_edge: PARENT_EDGE; new_type: TYPE): like Current is
		local
			args: like arguments
		do
			if arguments /= Void then
				args := arguments.specialize_thru(parent_type, parent_edge, new_type)
			end
			if args = arguments then
				Result := Current
			else
				Result := twin
				Result.set_arguments(args)
			end
		end

feature {E_ROUTINE}
	set_arguments (args: like arguments) is
		do
			arguments := args
		end

feature {INSPECT_STATEMENT}
	anchored_internal_local (type:TYPE; anchor_expression: EXPRESSION; position: POSITION; tag: STRING): INTERNAL_LOCAL is
			-- `anchor_expression' is the expression the returned local variable will be assigned to.
		do
			if internal_locals = Void then
				create internal_locals.make
			end
			Result := internal_locals.anchored(type, anchor_expression, position, tag)
		end

	typed_internal_local (type, base_type: TYPE; position: POSITION; tag: STRING): INTERNAL_LOCAL is
			-- `base_type' is the type of the returned local variable
		do
			if internal_locals = Void then
				create internal_locals.make
			end
			Result := internal_locals.typed(type, base_type, position, tag)
		end

feature {}
	make_routine (fa: like arguments; om: like obsolete_mark; hc: like header_comment; ra: like require_assertion) is
		do
			header_comment := hc
			arguments := fa
			obsolete_mark := om
			require_assertion := ra
		end

	pretty_print_routine_body is
		require
			pretty_printer.indent_level = 3
		deferred
		end

	pretty_print_rescue is
		deferred
		end

end -- class E_ROUTINE
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
