-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class EXTERNAL_FUNCTION
	--
	-- Call to a function of a foreign language.
	--

inherit
	EXTERNAL_ROUTINE
		redefine specialize_signature_in, specialize_signature_thru, hook_collect,
			inline_expression_0, inline_expression_1
		end

creation {FEATURE_TEXT}
	make

creation {CLASS_TEXT}
	non_written

feature {ANY}
	result_type: TYPE_MARK

	side_effect_free (target_type: TYPE): BOOLEAN is
		do
			Result := native.side_effect_free(target_type, feature_text)
		end

feature {CALL_0}
	inline_expression_0 (type: TYPE; feature_stamp: FEATURE_STAMP; target_type: TYPE; target: EXPRESSION
								return_type: TYPE): INLINE_MEMO is
		local
			name: STRING; ic1: INTEGER_CONSTANT; cc: CHARACTER_CONSTANT; sp: POSITION
			integer_type_mark: INTEGER_TYPE_MARK
		do
			name := first_name.to_string
			sp := start_position
			if name = as_stderr or else name = as_stdin or else name = as_stdout then
				Result := smart_eiffel.get_inline_memo
				Result.set_expression(create {NON_VOID_NO_DISPATCH}.make(return_type, feature_stamp, type))
			elseif name = as_is_expanded_type then
				if target.side_effect_free(type) then
					Result := smart_eiffel.get_inline_memo
					Result.set_expression(true_or_false(target_type.is_expanded, sp))
				end
			elseif name = as_is_basic_expanded_type then
				if target.side_effect_free(type) then
					Result := smart_eiffel.get_inline_memo
					Result.set_expression(true_or_false(target_type.is_kernel_expanded, sp))
				end
			end
			if Result = Void then
				ic1 ?= target
				if ic1 /= Void then
					--|*** error_handler.append("New code for inline in EXTERNAL_FUNCTION ??")
					--|*** error_handler.add_position(sp)
					--|*** error_handler.print_as_warning
				end
			end
			-- For the CHARACTER class:
			if Result = Void and then target_type.is_character then
				if name = as_code then
					cc ?= target
					if cc /= Void then
						Result := smart_eiffel.get_inline_memo
						integer_type_mark ?= return_type.canonical_type_mark --|*** ::=
						create ic1.with(cc.value.code, start_position, integer_type_mark)
						Result.set_expression(ic1)
					end
				elseif name = as_to_integer_8 then
					cc ?= target
					if cc /= Void then
						Result := smart_eiffel.get_inline_memo
						integer_type_mark ?= return_type.canonical_type_mark --|*** ::=
						create ic1.with(cc.value.to_integer_8, start_position, integer_type_mark)
						Result.set_expression(ic1)
					end
				end
			end
			if Result /= Void then
				smart_eiffel.magic_count_increment
			end
		end

feature {CALL_1}
	inline_expression_1 (type: TYPE; feature_stamp: FEATURE_STAMP; call_site: POSITION
		target_type: TYPE; target, arg: EXPRESSION; return_type: TYPE): INLINE_MEMO is
		local
			name: STRING; ic1, ic2: INTEGER_CONSTANT; bc1, bc2: BOOLEAN_CONSTANT
			integer_64: INTEGER_64; integer_tm: INTEGER_TYPE_MARK
		do
			name := first_name.to_string
			if name = as_is_equal and then target_type.is_kernel_expanded then
				Result := smart_eiffel.get_inline_memo
				Result.set_expression(create {BUILT_IN_EQ_NEQ}.make_eq(target, call_site, arg))
			end
			if Result = Void and then name = as_same_dynamic_type then
				if target_type = arg.resolve_in(type) and then
					target.side_effect_free(type) and then
					arg.side_effect_free(type)
				 then
					if target_type.is_expanded then
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(create {E_TRUE}.make(call_site))
					elseif target_type.live_type /= Void then
						if target_type.live_type.run_time_set.count = 1 then
							Result := smart_eiffel.get_inline_memo
							Result.set_expression(create {E_TRUE}.make(call_site))
						end
					end
				end
			end
			if Result = Void then
				ic1 ?= target
				ic2 ?= arg
				if ic1 /= Void and then ic2 /= Void then
					integer_tm := ic1.result_type
					if name = as_lt then
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(true_or_false(ic1.value_memory < ic2.value_memory, call_site))
					elseif name = as_le then
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(true_or_false(ic1.value_memory <= ic2.value_memory, call_site))
					elseif name = as_gt then
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(true_or_false(ic1.value_memory > ic2.value_memory, call_site))
					elseif name = as_ge then
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(true_or_false(ic1.value_memory >= ic2.value_memory, call_site))
					elseif name = as_sharp_plus then
						inspect
							integer_tm.bit_count
						when 8 then
							integer_64 := ic1.value_memory.to_integer_8 #+ ic2.value_memory.to_integer_8
						when 16 then
							integer_64 := ic1.value_memory.to_integer_16 #+ ic2.value_memory.to_integer_16
						when 32 then
							integer_64 := ic1.value_memory.to_integer_32 #+ ic2.value_memory.to_integer_32
						when 64 then
							integer_64 := ic1.value_memory #+ ic2.value_memory
						end
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(create {INTEGER_CONSTANT}.with(integer_64, call_site, integer_tm))
					elseif name = as_sharp_minus then
						inspect
							integer_tm.bit_count
						when 8 then
							integer_64 := ic1.value_memory.to_integer_8 #- ic2.value_memory.to_integer_8
						when 16 then
							integer_64 := ic1.value_memory.to_integer_16 #- ic2.value_memory.to_integer_16
						when 32 then
							integer_64 := ic1.value_memory.to_integer_32 #- ic2.value_memory.to_integer_32
						when 64 then
							integer_64 := ic1.value_memory #- ic2.value_memory
						end
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(create {INTEGER_CONSTANT}.with(integer_64, call_site, integer_tm))
					elseif name = as_sharp_muls then
						inspect
							integer_tm.bit_count
						when 8 then
							integer_64 := ic1.value_memory.to_integer_8 #* ic2.value_memory.to_integer_8
						when 16 then
							integer_64 := ic1.value_memory.to_integer_16 #* ic2.value_memory.to_integer_16
						when 32 then
							integer_64 := ic1.value_memory.to_integer_32 #* ic2.value_memory.to_integer_32
						when 64 then
							integer_64 := ic1.value_memory #* ic2.value_memory
						end
						Result := smart_eiffel.get_inline_memo
						Result.set_expression(create {INTEGER_CONSTANT}.with(integer_64, call_site, integer_tm))
					elseif name = as_sharp_slash_slash then
						if ic2.value_memory = 0 then
							--|*** Should we do a DIVIDE_BY_ZERO new NON_WRITTEN_EXPRESSION  ?
							--|*** (Dom. may 25th 2004) ***
						else
							integer_64 := ic1.value_memory #// ic2.value_memory
							Result := smart_eiffel.get_inline_memo
							Result.set_expression(create {INTEGER_CONSTANT}.with(integer_64, call_site, ic1.result_type))
						end
					elseif name = as_sharp_backslash_backslash then
						if ic2.value_memory = 0 then
							--|*** Should we do a DIVIDE_BY_ZERO new NON_WRITTEN_EXPRESSION  ?
							--|*** (Dom. may 25th 2004) ***
						else
							integer_64 := ic1.value_memory #\\ ic2.value_memory
							Result := smart_eiffel.get_inline_memo
							Result.set_expression(create {INTEGER_CONSTANT}.with(integer_64, call_site, ic1.result_type))
						end
					else
						--|*** error_handler.append("New code for inline in EXTERNAL_FUNCTION ??")
						--|*** error_handler.add_position(call_site)
						--|*** error_handler.print_as_warning
					end
				end
			end
			-- For the BOOLEAN class:
			if Result = Void and then target_type.is_boolean then
				if name = as_and_then then
					bc1 ?= target
					if bc1 /= Void then
						Result := smart_eiffel.get_inline_memo
						if bc1.value then
							Result.set_expression(arg)
						else
							Result.set_expression(create {E_FALSE}.make(call_site))
						end
					else
						bc2 ?= arg
						if bc2 /= Void then
							if bc2.value then
								Result := smart_eiffel.get_inline_memo
								Result.set_expression(target)
							elseif target.side_effect_free(type) then
								Result := smart_eiffel.get_inline_memo
								Result.set_expression(create {E_FALSE}.make(call_site))
							end
						end
					end
				elseif name = as_or_else then
					bc1 ?= target
					if bc1 /= Void then
						Result := smart_eiffel.get_inline_memo
						if bc1.value then
							Result.set_expression(create {E_TRUE}.make(call_site))
						else
							Result.set_expression(arg)
						end
					else
						bc2 ?= arg
						if bc2 /= Void then
							if bc2.value then
								if target.side_effect_free(type) then
									Result := smart_eiffel.get_inline_memo
									Result.set_expression(create {E_TRUE}.make(call_site))
								end
							else
								Result := smart_eiffel.get_inline_memo
								Result.set_expression(target)
							end
						end
					end
				elseif name = as_implies then
					bc1 ?= target
					if bc1 /= Void then
						Result := smart_eiffel.get_inline_memo
						if bc1.value then
							Result.set_expression(arg)
						else
							Result.set_expression(create {E_TRUE}.make(call_site))
						end
					end
					--|*** Check the value of `bc2' as for "or else" / "and then".
					--|*** (Dom may 28th 2004) ***
				else
					check
						False -- No other external functions in BOOLEAN.
					end
				end
			end
			if Result /= Void then
				smart_eiffel.magic_count_increment
			end
		end

feature {}
	true_or_false (bool: BOOLEAN; sp: POSITION): BOOLEAN_CONSTANT is
		do
			if bool then
				create {E_TRUE} Result.make(sp)
			else
				create {E_FALSE} Result.make(sp)
			end
		end

	new_run_feature_for (t: TYPE; fn: FEATURE_NAME): RUN_FEATURE_8 is
		do
			create Result.for(t.live_type, Current, fn)
		end

feature {ANY}
	accept (visitor: EXTERNAL_FUNCTION_VISITOR) is
		do
			visitor.visit_external_function(Current)
		end

feature {ANONYMOUS_FEATURE_MIXER}
	specialize_signature_in (new_type: TYPE): like Current is
		local
			args: like arguments; rt: like result_type
		do
			rt := result_type.specialize_in(new_type)
			if arguments /= Void then
				args := arguments.specialize_in(new_type)
			end
			if result_type = rt and then args = arguments then
				Result := Current
			else
				Result := twin
				Result.set_arguments(args)
				Result.set_result_type(rt)
			end
		end

	specialize_signature_thru (parent_type: TYPE; parent_edge: PARENT_EDGE; new_type: TYPE): like Current is
		local
			args: like arguments; rt: like result_type
		do
			rt := result_type.specialize_thru(parent_type, parent_edge, new_type)
			if arguments /= Void then
				args := arguments.specialize_thru(parent_type, parent_edge, new_type)
			end
			if result_type = rt and then args = arguments then
				Result := Current
			else
				Result := twin
				Result.set_arguments(args)
				Result.set_result_type(rt)
			end
		end

feature {}
	hook_collect (t: TYPE) is
		local
			n: STRING
			fs: FEATURE_STAMP
			insp: INSPECT_STATEMENT
		do
			n := first_name.to_string
			if as_twin = n then
				fs := any_copy_fs.resolve_static_binding_for(smart_eiffel.type_any, t)
				t.live_type.collect(fs)
			elseif as_calloc = n and then as_native_array = t.class_text.name.to_string then
				fs := t.feature_stamp_of(clear_all_name)
				t.live_type.collect(fs)
			elseif as_generating_type = n then
				smart_eiffel.set_generator_used
				smart_eiffel.set_generating_type_used
			elseif as_generator = n then
				smart_eiffel.set_generator_used
			elseif as_deep_twin = n then
				t.live_type.collect_deep_twin
			elseif as_is_deep_equal = n then
				t.live_type.collect_is_deep_equal
			elseif as_internals_handler = class_text.name.to_string then
				insp ::= routine_body
				if as_internals_from_generating_type = n then
					introspection_handler.collect_internals_from_generating_type(insp, start_position, t)
				elseif as_native_array_internals_from_generating_type = n then
					introspection_handler.collect_native_array_internals_from_generating_type(insp, start_position,
																													  arguments, t)
				elseif as_valid_generating_type_for_internals = n then
					introspection_handler.collect_valid_generating_type_for_internals(insp, t)
				elseif as_valid_generating_type_for_native_array_internals = n then
					introspection_handler.collect_valid_generating_type_for_native_array_internals(insp, t)
				end
			elseif as_exception = n then
				exceptions_handler.set_used
			elseif as_signal_number = n then
				exceptions_handler.set_used
			end
		end

feature {}
	frozen collect_body (type: TYPE) is
		local
			t: TYPE
		do
			t := result_type.resolve_in(type)
			if t.is_expanded then
				smart_eiffel.collect_external(t)
			elseif t.name.to_string = as_string then
				manifest_string_pool.collect_string(t)
			end
			if routine_body /= Void and then not type.is_deferred then
				if local_vars /= Void then
					local_vars.collect(type)
				end
				if internal_locals /= Void then
					internal_locals.collect(type)
				end
				routine_body.collect(type)
			end
			native.collect(type, Current)
		end

feature {EXTERNAL_FUNCTION}
	set_result_type (rt: like result_type) is
		require
			rt /= Void
		do
			result_type := rt
		end

feature {}
	make (fa: like arguments; rt: like result_type; om: like obsolete_mark; hc: like header_comment
		ra: like require_assertion; l: like native; en: like alias_string) is
		require
			rt /= Void
			l /= Void
		do
			make_routine(fa, om, hc, ra)
			result_type := rt
			make_external_routine(l, en)
		end

	non_written (ct: CLASS_TEXT; fn: FEATURE_NAME; fa: like arguments; rt: like result_type; l: like native) is
		require
			ct /= Void
			fn /= Void
			fa /= Void
			rt /= Void
			l /= Void
		do
			feature_text := ct.non_written(fn, Current)
			make(fa, rt, Void, Void, Void, l, Void)
		end

	try_to_undefine_aux (fn: FEATURE_NAME; bc: CLASS_TEXT): DEFERRED_ROUTINE is
		do
			create {DEFERRED_FUNCTION} Result.from_effective(fn, arguments, result_type, require_assertion, ensure_assertion, bc, permissions)
		end

end -- class EXTERNAL_FUNCTION
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
