-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
deferred class INSTRUCTION
	--
	-- For all differents kinds of Eiffel instruction.
	--

insert
	CODE

feature {ANY}
	specialize_2 (type: TYPE): INSTRUCTION is
		deferred
		end

	collect (t: TYPE) is
			-- (See comment of {EXPRESSION}.collect.)
		require
			has_been_specialized
			t.feature_collection_done
			smart_eiffel.status.is_collecting
			not smart_eiffel.status.is_specializing
		deferred
		end

	adapt_for (t: TYPE): like Current is
			-- (See comment of {EXPRESSION}.adapt_for.)
		require
			t /= Void
		deferred
		ensure
			Result /= Void
		end

	end_mark_comment: BOOLEAN is
			-- True for instructions which may have a possible "end" mark comment.
			-- As an example, it is True for a "loop", or an "inspect" statement.
			-- It is False for an assignment or for a simple procedure call.
		deferred
		end

	compile_to_jvm (type: TYPE) is
		require
			smart_eiffel.is_ready
			type.live_type /= Void
		deferred
		end

	frozen is_not_a_compound: BOOLEAN is
			-- Mostly for assertion checks.
		do
			Result := not {COMPOUND} ?:= Current
		ensure
			Result = not {COMPOUND} ?:= Current
		end

	accept (visitor: VISITOR) is
		deferred
		end

feature {ANONYMOUS_FEATURE, CODE, INTROSPECTION_HANDLER}
	simplify (type: TYPE): INSTRUCTION is
		deferred
		end

feature {ANONYMOUS_FEATURE, INSTRUCTION}
	simplify_routine_body_first (type: TYPE; return_type: TYPE): INSTRUCTION is
			-- Try to simplify Current knowing that `Current' is the first statement of some routine body 
			-- with _no_ rescue clause. A non Void `result_type' indicates that we are actually in the body of 
			-- some function.
		require
			not smart_eiffel.pretty_flag
			not smart_eiffel.short_or_class_check_flag
			smart_eiffel.status.collecting_done
			type /= Void
		do
			-- No simplication as the default behavior:
			Result := Current
		ensure
			Result /= Current or Result = Void implies smart_eiffel.magic_count > old smart_eiffel.magic_count
			Result = Current implies smart_eiffel.magic_count = old smart_eiffel.magic_count
		end

end -- class INSTRUCTION
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
