-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
deferred class WHEN_ITEM
	--
	-- A part of the inspect instruction.
	-- There are two descendant WHEN_ITEM_1 (for a single value) and WHEN_ITEM_2 (for a slice).
	--

inherit
	VISITABLE
insert
	GLOBALS

feature {ANY}
	start_position: POSITION is
		deferred
		end

feature {WHEN_CLAUSE}
	validity_check (original_inspect: INSPECT_STATEMENT) is
		require
			original_inspect.first_one.item = original_inspect
		do
			original_inspect.validity_check_continued(Current)
		end

	validity_check_continued (occurrence_1: WHEN_ITEM): BOOLEAN is
		require
			occurrence_1 /= Void
		do
			if Current = occurrence_1 then
				Result := True
			else
				validity_check_continued_(occurrence_1)
			end
		end

	validity_check_continued_ (occurrence_1: WHEN_ITEM) is
		require
			occurrence_1 /= Void
		deferred
		end

	collect (t: TYPE) is
		require
			has_been_specialized
			t.feature_collection_done
			smart_eiffel.status.is_collecting
			not smart_eiffel.status.is_specializing
		deferred
		end

	adapt_for (t: TYPE): like Current is
			--|*** May become a procedure because this is always static ???
			--|*** (Dom. 20 dec 2003)
		deferred
		end

	specialize_in (new_type: TYPE): like Current is
			--|*** May become a procedure because this is always static ???
			--|*** (Dom. 20 dec 2003)
		require
			new_type /= Void
		deferred
		ensure
			Result.has_been_specialized
		end

	specialize_thru (parent_type: TYPE; parent_edge: PARENT_EDGE; new_type: TYPE): like Current is
			--|*** May become a procedure because this is always static ???
			--|*** (Dom. 20 dec 2003)
		require
			parent_type /= Void
			parent_edge /= Void
			new_type /= Void
			new_type /= parent_type
			has_been_specialized
		deferred
		ensure
			has_been_specialized
			Result.has_been_specialized
		end

	specialize_2_character (type: TYPE): like Current is
			--|*** May become a procedure because this is always static ???
			--|*** (Dom. 20 dec 2003)
		require
			has_been_specialized
			not smart_eiffel.status.is_specializing
		deferred
		ensure
			has_been_specialized
			Result.has_been_specialized
		end

	specialize_2_integer (type: TYPE): like Current is
			--|*** May become a procedure because this is always static ???
			--|*** (Dom. 20 dec 2003)
		require
			has_been_specialized
			not smart_eiffel.status.is_specializing
		deferred
		ensure
			has_been_specialized
			Result.has_been_specialized
		end

	specialize_2_string (type: TYPE): like Current is
			--|*** May become a procedure because this is always static ???
			--|*** (Dom. 20 dec 2003)
		require
			has_been_specialized
			not smart_eiffel.status.is_specializing
		deferred
		ensure
			has_been_specialized
			Result.has_been_specialized
		end

	compute_values (container: WHEN_CLAUSE) is
		require
			container /= Void
		deferred
		end

	force_internal_character_values (type: TYPE; container: WHEN_CLAUSE) is
		require
			container /= Void
		deferred
		end

	force_internal_integer_values (type: TYPE; container: WHEN_CLAUSE) is
		require
			container /= Void
		deferred
		end

	pretty (indent_level: INTEGER) is
		deferred
		end

	match_value (v: INTEGER): BOOLEAN is
		deferred
		end

feature {WHEN_CLAUSE, WHEN_ITEM}
	has_been_specialized: BOOLEAN is
		deferred
		ensure
			Result
		end

feature {}
	frozen manifest_expression_check (expression: EXPRESSION; lookup_type: TYPE): MANIFEST_EXPRESSION is
			-- Check that the `expression' is a valid bound for a when item (i.e. this is a statically
			-- computable expression).
		require
			expression /= Void
		local
			call_0: CALL_0
		do
			Result ?= expression
			if Result = Void then
				call_0 ?= expression
				check
					call_0 /= Void -- (Actually, this is already checked in `eiffel_parser'.)
				end
				Result := call_0.manifest_expression(lookup_type)
			end
		ensure
			Result /= Void
		end

	frozen integer_check (e: EXPRESSION; me: MANIFEST_EXPRESSION): INTEGER is
			-- Where `e' is `me' itself or the corresponding static call.
		require
			e /= Void
			me /= Void
		local
			integer_constant: INTEGER_CONSTANT
		do
			integer_constant ?= me
			if integer_constant = Void then
				error_handler.add_position(e.start_position)
				error_handler.append("This is not an INTEGER expression.")
				explain_fatal_error(e, me)
			end
			Result := integer_constant.value_memory.to_integer_32
		end

	frozen character_check (e: EXPRESSION; me: MANIFEST_EXPRESSION): INTEGER is
			-- Where `e' is `me' itself or the corresponding static call.
		require
			e /= Void
			me /= Void
		local
			character_constant: CHARACTER_CONSTANT
		do
			character_constant ?= me
			if character_constant = Void then
				error_handler.add_position(e.start_position)
				error_handler.append("This is not an CHARACTER expression.")
				explain_fatal_error(e, me)
			end
			Result := character_constant.value.code
		end

	frozen explain_fatal_error (e: EXPRESSION; me: MANIFEST_EXPRESSION) is
			-- Where `e' is `me' itself or the corresponding static call.
		require
			e /= Void
			me /= Void
		do
			if e /= me then
				error_handler.append("(The corresponding feature definition is in the next error message.)")
				error_handler.print_as_error
				error_handler.add_position(me.start_position)
				error_handler.append("The corresponding feature definition.")
			end
			error_handler.print_as_fatal_error
		end

feature {WHEN_ITEM_1}
	validity_check_continued_when_item_1 (occurrence_2: WHEN_ITEM_1) is
		require
			occurrence_2 /= Void
		deferred
		end

feature {WHEN_ITEM_2}
	validity_check_continued_when_item_2 (occurrence_2: WHEN_ITEM_2) is
		require
			occurrence_2 /= Void
		deferred
		end

end -- class WHEN_ITEM
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
