-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class E_ENSURE
	--
	-- To store a `ensure' clause.
	--

inherit
	ASSERTION_LIST
		rename make as assertion_list_make
		end
insert
	ASSERTION_PRINT_TOOLS

creation {ANY}
	make

feature {ANY}
	is_ensure_then: BOOLEAN

	compile_to_c (type: TYPE) is
		do
			compile_to_c_(type, True, True)
		end

	pretty_print is
		do
			if is_ensure_then then
				pretty_print_(2, once "ensure then")
			else
				pretty_print_(2, once "ensure")
			end
		end

	short (type: TYPE; client: CLASS_NAME) is
		local
			i: INTEGER
		do
			tmp_assertion_list.clear_count
			if list /= Void then
				from
					i := 0
				until
					i > list.upper
				loop
					if client = Void or else not hidden_expression_detector.visit(list.item(i), type, client, False) then
						tmp_assertion_list.add_last(list.item(i))
					end
					i := i + 1
				end
			end
			if header_comment /= Void or else not tmp_assertion_list.is_empty then
				short_printer.hook_or(once "hook511", "      ensure%N")
				if header_comment = Void then
					short_printer.hook_or(once "hook512", once "")
				else
					short_printer.hook_or(once "hook513", once "")
					header_comment.short(once "hook514", once "         --", once "hook515", once "%N")
					short_printer.hook_or(once "hook516", once "")
				end
				if tmp_assertion_list.is_empty then
					short_printer.hook_or(once "hook517", once "")
				else
					short_printer.hook_or(once "hook518", once "")
					from
						i := tmp_assertion_list.lower
					until
						i = tmp_assertion_list.upper
					loop
						tmp_assertion_list.item(i).short(type, once "hook519", once "         ", once "hook520" -- before each assertion
						, once "", once "hook521" -- no tag
						, once "", once "hook522" -- before tag
						, once ": ", once "hook523" -- after tag
						, once "", once "hook524" -- no expression
						, once "", once "hook525" -- before expression
						, once ";", once "hook526" -- after expression except last
						, once "%N", once "hook527" -- no comment
						, once "", once "hook528" -- before comment
						, once " --", once "hook529" -- comment begin line
						, once "%N", once "hook530" -- comment end of line
						, once "", once "hook531" -- after comment
						, once "")
						-- end of each assertion
						i := i + 1
					end
					tmp_assertion_list.item(i).short(type, once "hook519", once "         ", once "hook520" -- before each assertion
					, once "", once "hook521" -- no tag
					, once "", once "hook522" -- before tag
					, once ": ", once "hook523" -- after tag
					, once "", once "hook524" -- no expression
					, once "", once "hook532" -- before expression
					, once "", once "hook526" -- after expression except last
					, once "%N", once "hook527" -- no comment
					, once "", once "hook528" -- before comment
					, once " --", once "hook529" -- comment begin line
					, once "%N", once "hook530" -- comment end of line
					, once "", once "hook531" -- after comment
					, once "")
					-- end of each assertion
					short_printer.hook_or(once "hook533", once "")
				end
				short_printer.hook_or(once "hook534", once "")
			end
		end

	accept (visitor: E_ENSURE_VISITOR) is
		do
			visitor.visit_e_ensure(Current)
		end

feature {ANONYMOUS_FEATURE_MIXER}
	add_parent_ensure (parent_ensure: like Current): like Current is
			-- Add `parent_ensure' to `Current' only if it is really new code (i.e. using `start_position' to decide.).
		require
			not start_position.is_unknown
			not parent_ensure.start_position.is_unknown
			--|*** Verifier que parent_ensure viens bien d'une classe au dessus ...
			-- faire pareil dans E_REQUIRE
		local
			l: like list; i: INTEGER; a: ASSERTION
		do
			Result := Current
			if start_position /= parent_ensure.start_position then
				l := parent_ensure.list
				if l /= Void then
					if list = Void then
						Result := twin
						Result.set_list(l.twin)
					else
						from
							i := l.lower
						until
							i > l.upper
						loop
							a := l.item(i)
							if not Current.has_assertion_located_at(a.start_position) then
								if Result = Current then
									Result := twin
									Result.set_list(list.twin)
								end
								Result.list.add_last(a)
							end
							i := i + 1
						end
					end
				end
			end
		ensure
			Result.start_position = start_position
		end

feature {ANONYMOUS_FEATURE}
	new: like Current is
		local
			l: like list
		do
			Result := twin
			create l.from_collection(list)
			Result.set_list(l)
		end

feature {}
	make (sp: like start_position; then_flag: BOOLEAN; hc: like header_comment; l: like list) is
		do
			assertion_list_make(sp, hc, l)
			is_ensure_then := then_flag
		ensure
			is_ensure_then = then_flag
		end

	check_assertion_mode: STRING is "ens"

end -- class E_ENSURE
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
