-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class INLINE_MEMO
	--
	-- Used to store the result of an inlining attempt.
	--

creation {SMART_EIFFEL}
	make

feature {ANY}
	expression: EXPRESSION is
		do
			Result := expression_memory
		ensure
			Result /= Void
		end

	instruction: INSTRUCTION

	cleared: BOOLEAN is
		do
			Result := instruction = Void and then expression_memory = Void
		end

	is_instruction_holder: BOOLEAN is
		do
			Result := expression_memory = Void
		end

	is_expression_holder: BOOLEAN is
		do
			Result := expression_memory /= Void and then instruction = Void
		end

feature {ANONYMOUS_FEATURE}
	set_expression (e: like expression) is
		require
			e /= Void
			instruction = Void
		do
			expression_memory := e
		ensure
			expression = e
		end

	set_instruction (i: like instruction) is
		require
			expression_memory = Void
		do
			instruction := i
		ensure
			instruction = i
		end

feature {SMART_EIFFEL}
	clear is
		do
			expression_memory := Void
			instruction := Void
		end

feature {}
	expression_memory: EXPRESSION

	make is
		do
		end

end -- class INLINE_MEMO
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
