-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class INTERNAL_LOCAL_LIST

insert
	GLOBALS

creation {E_ROUTINE}
	make

feature {E_ROUTINE}
	anchored (type: TYPE; anchor_expression: EXPRESSION; position: POSITION; tag: STRING): INTERNAL_LOCAL is
		local
			loc: FAST_ARRAY[INTERNAL_LOCAL]
		do
			loc := locals.reference_at(type)
			if loc = Void then
				create loc.make(0)
				locals.add(loc, type)
			end
			create Result.anchored(string_aliaser.hashed_string(name(loc)), anchor_expression, position, tag)
			loc.add_last(Result)
		end

	typed (type, base_type: TYPE; position: POSITION; tag: STRING): INTERNAL_LOCAL is
		local
			loc: FAST_ARRAY[INTERNAL_LOCAL]
		do
			loc := locals.reference_at(type)
			if loc = Void then
				create loc.make(0)
				locals.add(loc, type)
			end
			create Result.typed(string_aliaser.hashed_string(name(loc)), base_type, position, tag)
			loc.add_last(Result)
		end

	collect (t: TYPE) is
		local
			i: INTEGER; t2: TYPE
		do
			collected := locals.at(t)
			from
				i := collected.lower
			until
				i > collected.upper
			loop
				t2 := collected.item(i).written_declaration_type_mark.resolve_in(t)
				if t2.is_expanded then
					smart_eiffel.collect_local_expanded(t2)
				end
				i := i + 1
			end
		end

	side_effect_free (type: TYPE): BOOLEAN is
		local
			i, j: INTEGER; static_tm: TYPE_MARK
		do
			from
				Result := True
				i := locals.lower
			until
				not Result or else i > locals.upper
			loop
				from
					j := locals.item(i).lower
				until
					not Result or else j > locals.item(i).upper
				loop
					Result := locals.item(i).item(j).side_effect_free(type)
					j := j + 1
				end
				i := i + 1
			end
		end

	has_been_specialized: BOOLEAN is
		local
			i, j: INTEGER
		do
			from
				Result := True
				i := locals.lower
			until
				not Result or else i > locals.upper
			loop
				from
					j := locals.item(i).lower
				until
					not Result or else j > locals.item(i).upper
				loop
					Result := locals.item(i).item(j).has_been_specialized
					j := j + 1
				end
				i := i + 1
			end
		end

feature {RUN_FEATURE}
	c_declare (type: TYPE; volatile_flag: BOOLEAN) is
			-- Generate the C code for the declaration part. The `volatile_flag' indicate that an extra
			-- volatile C keyword must be generated because we are in the case of a routine with a rescue
			-- clause.
		local
			i: INTEGER
		do
			from
				i := collected.lower
			until
				i > collected.upper
			loop
				collected.item(i).c_declare(type, volatile_flag)
				i := i + 1
			end
		end

feature {}
	make is
		do
			create locals.make
		end

	locals: HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL], TYPE]
	collected: FAST_ARRAY[INTERNAL_LOCAL]

	name (loc: FAST_ARRAY[INTERNAL_LOCAL]): STRING is
		do
			Result := once ""
			Result.clear_count
			loc.count.append_in(Result)
		end

invariant
	locals /= Void

end -- class INTERNAL_LOCAL_LIST
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
