-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class SWITCH_TYPE
	--
	-- All SWITH_SITEs for a given TYPE.
	--

insert
	GLOBALS

creation {SWITCH_COLLECTION}
	make

feature {ANY}
	type: LIVE_TYPE
			-- the type associated to those switch sites

	site (feature_name: FEATURE_NAME): SWITCH_SITE is
		do
			Result := branches.reference_at(feature_name)
		ensure
			Result /= Void implies Result.feature_name = feature_name
		end

	add_site (s: SWITCH_SITE) is
		require
			site(s.feature_name) = Void
		do
			branches.add(s, s.feature_name)
		ensure
			site(s.feature_name) = s
		end

	item (i: INTEGER): SWITCH_SITE is
		require
			i.in_range(1, count)
		do
			Result := branches.item(i)
		end

	count: INTEGER is
		do
			Result := branches.count
		end

feature {SWITCH_COLLECTION}
	jvm_define: INTEGER is
			-- The `Result' is the number of switches.
		local
			i: INTEGER
		do
			from
				i := 1
			until
				i > branches.count
			loop
				branches.item(i).jvm_define
				Result := Result + 1
				i := i + 1
			end
		end
	
feature {}
	make (t: like type) is
		require
			t /= Void
		do
			type := t
			create branches.make
		ensure
			type = t
		end

	branches: HASHED_DICTIONARY[SWITCH_SITE, FEATURE_NAME]

invariant
	type /= Void

end -- class SWITCH_TYPE
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
