/***************************************************************************
    smb4kbookmark.h  - A bookmark container.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMB4KBOOKMARK_H
#define SMB4KBOOKMARK_H

// Qt includes
#include <qstring.h>

/**
 * This class is a container for a setted bookmark on a samba share
 */
class Smb4KBookmark
{
  public:
    Smb4KBookmark(const QString &share);
    Smb4KBookmark() {}
    ~Smb4KBookmark();

    QString getShare() const;
    
  private:
    QString m_share;
};

inline bool operator<( const Smb4KBookmark &b1, const Smb4KBookmark &b2 )
{
  return qstrcmp( b1.getShare().ascii() , b2.getShare().ascii() ) < 0;
}

#endif
