/***************************************************************************
    smb4kpasswdreader.h  -  Reads passwords. Used by several classes.
                             -------------------
    begin                : Mit Mai 14 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KPASSWDREADER_H
#define SMB4KPASSWDREADER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qstringlist.h>

// KDE includes
#include <kconfig.h>
#include <kdialogbase.h>
#include <klineedit.h>

// application specific includes
#include "smb4kauthinfo.h"


/** This is a core class. It handles the reading and writing of the
    login information. It also provides the askpass dialog. */

class Smb4KPasswdReader : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KPasswdReader( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KPasswdReader();
    /**
     * Reads the requested authentication data and returns a pointer to it.
     */
    Smb4KAuthInfo *getAuth( const QString &workgroup, const QString &host, const QString &share );
    /**
     * Returns the list of authentication data stored in the password 
     * file.
     */
    const QValueList<Smb4KAuthInfo *> &getAuthList() { return m_list; }
    /** 
     * Reads the default auth data and returns a pointer to it. The 
     * workgroup, host, and share objects are empty.
     */
    Smb4KAuthInfo *readDefaultAuthData();
    /** 
     * Writes the default authentication data to the password file. 
     */
    void writeDefaultAuthData( Smb4KAuthInfo *auth );
    /** 
     * This function commits authentication data.
     */
    void commit( Smb4KAuthInfo *auth );
    /** 
     * The askpass. Returns true, if the user supplied auth data and pressed OK. Otherwise
     * false is returned. 
     */
    bool askpass( const QString &workgroup, const QString &host, const QString &share );  
    /**
     * Updates the list of authentication infos.
     */
    void updateAuthList( const QValueList<Smb4KAuthInfo *> &list );
    
  protected slots:
    /**
     * Get the password for a specified user. Only used for homes shares.
     */
    void slotGetPassword( const QString &user );

  private:
    /**
     * This function takes a list of authentication information and 
     * writes it to the password file.
     */
    void write();
    /**
     * Reads the list of authentication data.
     */
    void read();
    /** 
     * This function obfuscates/decrypts the passwords. 
     */
    const QString obfuscate( const QString &password, bool encrypt );
    /**
     * The KConfig object.
     */
    KConfig *m_config;
    /** 
     * The key used for the password obfuscation. 
     */
    int m_key;
    /** 
     * The askpass widget. 
     */
    KDialogBase *passwdDlg;
    /**
     * The password line edit.
     */
    KLineEdit *m_passwdEdit;
    /**
     * Holds the list of authentication data.
     */
    QValueList<Smb4KAuthInfo *> m_list;
#ifdef __FreeBSD__
    /**
     * Process the ~/.nsmbrc file.
     */
    void writeToSMBConfFile();
#endif
};
#endif
