/***************************************************************************
                          smb4kshare  -  description
                             -------------------
    begin                : Do Mr 4 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSHARE_H
#define SMB4KSHARE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

// application specific includes
#include "smb4kuser.h"

/** 
 * This class encapsulate the reprensatation of a mounted share object. 
 */

class Smb4KShare
{
  public:
    /**
     * The constructor
     */
    Smb4KShare( const QString &name, const QString &path, const int uid = 0, const int gid = 0 );
    /**
     * Empty constructor.
     */
    Smb4KShare() {}
    /**
     * Copy constructor.
     */
    Smb4KShare( const Smb4KShare &share );
    /**
     * The destructor
     */
    ~Smb4KShare();
    /**
     * Returns the name of the share. All spaces are replaced
     * by underscores.
     */
    QString getName() const;
    /**
     * Returns the real name of the share.
     */
    QString getRealName() const;
    /**
     * Returns the path (mount point) of the share.
     */
    QString getPath() const;
    /**
     * Returns the UID of the mounted share.
     */
    int getUID() const;
    /**
     * Returns the GID of the mounted share.
     */
    int getGID() const;
    /**
     * Returns the name of the user of the share.
     */
    QString getUser() const;
    /**
     * Returns the name of the group of the share.
     */
    QString getGroup() const;    
    /**
     * This function clears an Smb4KShare object.
     */
    void clear();
    /**
     * Returns true, if the Smb4KShare object is empty.
     */
    bool isEmpty();

  private:
    QString m_name;
    QString m_path;
    Smb4KUser m_userinfo;
};

#endif
