/***************************************************************************
    smb4kshellio  -  This class takes care of all shell IO operations, 
    that are not connected to mounting and unmounting of shares or
    network operations.
                             -------------------
    begin                : Sa Mai 29 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSHELLIO_H
#define SMB4KSHELLIO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qtimer.h>
#include <qptrqueue.h>
#include <qstring.h>


class Smb4KShellIO : public QObject
{
  Q_OBJECT
  
  public:
    /**
     * The constructor.
     */
    Smb4KShellIO( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KShellIO();
    /**
     * This function determines the disk usage of a share.
     * It takes the full path of the share.
     */
    void getDiskUsage( const QString &path );
    
  signals:
    /**
     * This signal is emitted, when the path of a share is
     * empty. This is used by getDiskUsage().
     */
    void emptyPath();
    /**
     * Emits the usage of the selected share.
     */
    void usage( int total, int used, int free, int percent );
    
  protected slots:
    /**
     * Processes the inputs.
     */
    void slotFillQueue();
    /**
     * Is called, when the process exited.
     */
    void slotProcessExited( KProcess * );
    /**
     * Receives the output of the process.
     */
    void slotOutput( KProcess *p, char *buf, int len );
    /**
     * Starts processing the shell commands.
     */
    void slotProcess();
    
  private:
    /**
     * First timer. It helps processing the inputs.
     */
    QTimer *m_timer1;
    /**
     * Second timer. It helps processing the queue entries.
     */
    QTimer *m_timer2;
    /**
     * The path for the disk usage detection.
     */
    QString m_df_path;
    /**
     * The buffer for the df process.
     */
    QString m_buffer;
    /**
     * The queue that holds the stuff that has to be
     * processed.
     */
    QPtrQueue<QString> m_queue;
    /**
     * Enumeration.
     */
    enum TODO{ Usage };
    /**
     * The state the process is in.
     */
    int m_state;
    /**
     * The KProcess object.
     */
    KProcess *m_proc;
    /**
     * Processes the output of 'df'
     */
    void processUsage();
};


#endif
