/***************************************************************************
    main.cpp  -  Main file of the Smb4K program.
                             -------------------
    begin                : Sam Mr  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kiconloader.h>

#include "smb4k.h"
#include "core/smb4kstarter.h"

static const char *description = 
I18N_NOOP( "Smb4K is an SMB share browser for KDE.\nIt uses Samba to access the local network neighborhood." );
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
  
  
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "smb4k", I18N_NOOP( "Smb4K" ),
  VERSION, description, KAboutData::License_GPL,
  I18N_NOOP( "(c) 2003, Alexander Reinholdt\n(c) 2004, Alexander Reinholdt, Franck Babin" ), 0, "http://smb4k.berlios.de", "smb4k_bugs@web.de");

  // Authors:
  aboutData.addAuthor( "Alexander Reinholdt", I18N_NOOP( "Developer" ), "dustpuppy@mail.berlios.de" );
  aboutData.addAuthor( "Franck Babin", I18N_NOOP( "Developer" ), "babinfranck@yahoo.ca" );
//  aboutData.addAuthor( 
  
  // All our credits:
  aboutData.addCredit( "Leopold Palomo Avellaneda", I18N_NOOP( "Catalan translation" ), "lepalom@wol.es" );
  aboutData.addCredit( "Radoslaw Zawartko", I18N_NOOP( "Polish translation" ), "radzaw@lnet.szn.pl" );
  aboutData.addCredit( "Nick Chen", I18N_NOOP( "Chinese Simplified translation" ), "nickflyer@sina.com" );
  aboutData.addCredit( "Stanislav Yudin", I18N_NOOP( "Russian translation" ), "decvar@mail.berlios.de" );
  aboutData.addCredit( "Marc Hansen", I18N_NOOP( "Swedish translation and intensive testing" ), "marc.hansen@gmx.de" );
  aboutData.addCredit( "Giovanni Degani", I18N_NOOP( "Brazilian Portuguese translation" ), "tiefox@terra.com.br" );
  aboutData.addCredit( "Ivan Petrouchtchak", I18N_NOOP( "Ukrainian translation" ), "iip@telus.net" );
  aboutData.addCredit( "Karoly Barcza", I18N_NOOP( "Hungarian translation" ), "vector@vstart.hu" );
  aboutData.addCredit( "Quique", I18N_NOOP( "Spanish translation" ), "quique@sindominio.net" );
  aboutData.addCredit( "Michal Sulek", I18N_NOOP( "Slovak translation" ), "reloadshot@atlas.sk" );
  aboutData.addCredit( "Nicolas Ternisien", I18N_NOOP( "French translation" ), "nicolast@libertysurf.fr" );
  aboutData.addCredit( "Toyohiro Asukai", I18N_NOOP( "Japanese translation" ), "toyohiro@ksmplus.com" );
  aboutData.addCredit( "Atanas Mavrov", I18N_NOOP( "Bulgarian translation" ), "bugar@developer.bg" );
  aboutData.addCredit( "Isidoro Russo", I18N_NOOP( "Italian translation" ), "risidoro@aliceposta.it" );
  aboutData.addCredit( "Nils Kristian Tomren", I18N_NOOP( "Norwegian translations" ), "project@nilsk.net" );
  aboutData.addCredit( "Rashid N. Achilov", I18N_NOOP( "Testing of Smb4K under FreeBSD" ), "shelton@sentry.granch.ru" ); 
   
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;

  Smb4KStarter starter;
  starter.init();

  return app.exec();
}  
