/***************************************************************************
                          smb4kview.cpp  -  description
                             -------------------
    begin                : Sam Mr  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qtooltip.h>
 
// KDE includes
#include <klocale.h>
#include <kiconloader.h>
#include <kaccel.h>
#include <kshortcut.h>

// application specific includes
#include "smb4kview.h"

Smb4KView::Smb4KView( QWidget *parent, const char *name ) : QSplitter( parent, name )
{
  m_NetworkView = new Smb4KBrowserWidget( this, "NetworkView" );

  m_container = new QSplitter( Vertical, this, "Container" );
  m_ShareView = new Smb4KShareWidget( m_container, "SharesView" );
  m_tabWidget = new QTabWidget( m_container, 0 );

  m_NetworkTab = new Smb4KNetworkTab( m_container );
  QIconSet tab1Set( SmallIcon( "network" ), QIconSet::Automatic );
  m_tabWidget->insertTab( m_NetworkTab, tab1Set, i18n( "Network" ), 0 );

  m_ShareTab = new Smb4KShareTab( m_container );
  QIconSet tab2Set( SmallIcon( "hdd_mount" ), QIconSet::Automatic );
  m_tabWidget->insertTab( m_ShareTab, tab2Set, i18n( "Share" ), 1 );

  m_SearchTab = new Smb4KSearchTab( m_container );
  QIconSet tab3Set( SmallIcon( "find" ), QIconSet::Automatic );
  m_tabWidget->insertTab( m_SearchTab, tab3Set, i18n( "Search" ), 2 );

  setTooltips();
  
  // The user should be able to navigate through the tabs.
  KAccel *accel = new KAccel( this );
  // Network tab.
  accel->insert( i18n( "Show network tab" ), CTRL+Key_1, this, SLOT( slotShowNetworkTab() ), false, true );
  // Share tab.
  accel->insert( i18n( "Show Share tab" ), CTRL+Key_2, this, SLOT( slotShowShareTab() ), false, true );
  // The search tab.
  accel->insert( i18n( "Show Search tab" ), CTRL+Key_3, this, SLOT( slotShowSearchTab() ), false, true );
}

          
Smb4KView::~Smb4KView()
{
}


void Smb4KView::setTooltips()
{
  QToolTip::add( m_NetworkView, i18n( "Network neighborhood" ) );
  QToolTip::add( m_ShareView, i18n( "Mounted network shares" ) );
  QToolTip::add( m_SearchTab->m_window, i18n( "Search results" ) );
  QToolTip::add( m_SearchTab->m_input, i18n( "Enter host here" ) );
}

/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KView::slotShowNetworkTab()
{
  m_tabWidget->showPage( m_NetworkTab );
}


void Smb4KView::slotShowShareTab()
{
  m_tabWidget->showPage( m_ShareTab );
}


void Smb4KView::slotShowSearchTab()
{
  m_tabWidget->showPage( m_SearchTab );
  m_SearchTab->m_input->setFocus();
}


#include "smb4kview.moc"
