/***************************************************************************
                          smb4kview.h  -  description
                             -------------------
    begin                : Sam Mr  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KVIEW_H
#define SMB4KVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qsplitter.h>
#include <qtabwidget.h>

// application specific includes
#include "widgets/smb4kbrowserwidget.h"
#include "widgets/smb4ksharewidget.h"
#include "widgets/smb4ksharetab.h"
#include "widgets/smb4knetworktab.h"
#include "widgets/smb4ksearchtab.h"

/** The Smb4KView class provides the view widget for the Smb4KApp instance.
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As Smb4KView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the Smb4KApp class to manipulate and display
 * the document structure provided by the Smb4KDoc class.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class Smb4KView : public QSplitter
{
  Q_OBJECT

  friend class Smb4KApp;

  public:
    /** Constructor for the main view */
    Smb4KView(QWidget *parent = 0, const char *name=0);
    /**
     * Destructor for the main view
     */
    ~Smb4KView();
    /**
     * This function returns the pointer to the browser widget.
     */
    Smb4KBrowserWidget *networkView() { return m_NetworkView; }
    /**
     * This function returns the pointer to the share tab.
     */
    Smb4KShareTab *shareTab() { return m_ShareTab; }
    /** 
     * This function returns the pointer to the shares view. 
     */
    Smb4KShareWidget *shareView() { return m_ShareView; }
    /**
     * This funtion returns the pointer to the network tab.
     */
    Smb4KNetworkTab *networkTab() { return m_NetworkTab; }
    
  protected slots:
    /** 
     * Shows the network tab. 
     */
    void slotShowNetworkTab();
    /** 
     * Shows the share tab. 
     */
    void slotShowShareTab();
    /** 
     * Shows the search tab. 
     */
    void slotShowSearchTab();

  private:
    QSplitter *m_container;
    QTabWidget *m_tabWidget;
    Smb4KBrowserWidget *m_NetworkView;
    Smb4KShareWidget *m_ShareView;
    Smb4KNetworkTab *m_NetworkTab;
    Smb4KShareTab *m_ShareTab;
    Smb4KSearchTab *m_SearchTab;
    /** Sets the tooltips for the main window. */
    void setTooltips();
};

#endif // SMB4KVIEW_H
