/***************************************************************************
    smb4ksharewidget.h  -  The widget, that displays the mounted shares.
                             -------------------
    begin                : Sam Mr 1 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSHAREWIDGET_H
#define SMB4KSHAREWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstringlist.h>
#include <qpainter.h>
#include <qpalette.h>

// KDE includes
#include <kiconview.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

// Application includes
#include "../core/smb4kshare.h"

/** 
 * This class provides the ability display the mounted shares
 * and manipulate them.
 */
class Smb4KShareWidgetItem;
class Smb4KShareWidget : public KIconView
{
  Q_OBJECT

  friend class Smb4KApp;
  friend class Smb4KShareWidgetItem;
  
  public:
    /** 
     * The constructor. 
     */
    Smb4KShareWidget( QWidget *parent = 0, const char *name = 0 );
    /** 
     * The destructor. 
     */
    ~Smb4KShareWidget();
    /** 
     * Reads the options. 
     */
    void readOptions();

  protected slots:
    /** Is called by the menu. Does the unmounting. */
    void slotUnmountShare();
    /** Is called by the menu. Unmounts all shares at once. */
    void slotUnmountAllShares();
    /** Is called by the menu. Forces the unmount of a share. */
    void slotForceUnmountShare();
    /** Is called to import mounted shares into the share view. */
    void slotMountedShares();
    /** Is called, when a share has been mounted. */
    void slotMountedShare(Smb4KShare *share);
    /** Is called, when a share has been unmounted. */
    void slotUnmountedShare();
    /** Is called, when all shares have been unmounted. */
    void slotUnmountedAllShares();
    /** 
     * Is called, when a share is to be opened with the filemanager.
     * This slot behaves exactly the same as slotItemExecuted(), except
     * this is an external one. 
     */
    void slotOpenFilemanager();
    /** Is called, every time a mouse button has been pressed. */
    void slotMouseButtonPressed( int button, QIconViewItem *item, const QPoint &pos );
    /** Is called, when the the selection in the icon view changed. */
    void slotSelectionChanged( QIconViewItem *item );
    
  private:
    /** The KConfig variable. */
    KConfig *m_config;
    /** Holds the display style. */
    QString m_display;
    /** Holds whether the mount point should be shown as description. */
    bool m_mountpoint;
    /** The popup menu. */
    KPopupMenu *m_menu;
    enum ID{ Title, Unmount, ForcedUnmount, UnmountAll, Konqueror, IconView, ListView };
    QString m_workgroup, m_host, m_share;
    /** Holds the uid of the user. */
    int m_uid;
    /** Holds the gid of the user. */
    int m_gid;
    /** Determines whether all shares that were mounted should
        be shown. */
    bool m_showExternal;
    /** If the options are read this value is true. */
    bool m_read;
    /**
     * Determines whether the user wants to force the unmounting of
     * dead shares or not.
     */
    bool m_forcedUnmount;
};


/** 
 * This class handles the icon view items that are to be displayed.
 */
class Smb4KShareWidget;
class Smb4KShareWidgetItem : public KIconViewItem
{
  public:
    /**
     * The constructor. Please NOTE: The item does not have any text, when you only use this 
     * constructor. You have to call Smb4KShareWidgetItem::setText( const QString &text ) to
     * set the text!
     */
    Smb4KShareWidgetItem( Smb4KShareWidget *parent = 0, const QString &alignment = QString::null, const QString &name = QString::null, const QString &mountpoint = QString::null, int uid = 0, int gid = 0 );
    /**
     * The destructor.
     */
    virtual ~Smb4KShareWidgetItem();
    /**
     * Returns the UID of the item.
     */
    int uid() { return m_uid; }
    /**
     * Returns the GID of the item.
     */
    int gid() { return m_gid; }
    /**
     * Returns the name of the share.
     */
    QString name() { return m_sharename; }
    /**
     * Returns the mountpoint of this share.
     */
    QString mountpoint() { return m_mountpoint; }

  protected:
    /**
     * Reimplemented from QIconViewItem.
     */
    void paintItem( QPainter *p, const QColorGroup &cg );
  
  private:
    /**
     * Determines whether the share that is going to be imported, belongs to the
     * user or not.
     */
    bool m_foreignMount;
    /**
     * Holds the UID of this share.
     */
    int m_uid;
    /**
     * Holds the GID of this share.
     */
    int m_gid;
    /**
     * Holds the name of the share.
     */
    QString m_sharename;
    /** 
     * Holds the mountpoint of this share.
     */
    QString m_mountpoint;
};
#endif
