/***************************************************************************
    smb4kipfinder.h  -  This class takes care of the IP address detection
    of the hosts in the browser window.
                             -------------------
    begin                : Son Feb 22 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KIPFINDER_H
#define SMB4KIPFINDER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qtimer.h>
#include <qstringlist.h>
#include <qptrqueue.h>

// KDE includes
#include <kprocess.h>
#include <kconfig.h>

// application specific includes
#include "smb4kdefs.h"
#include "smb4knetworkitems.h"



/**
 * This class checks for the IP addresses of the hosts that were found by
 * the scanner.
 */

class Smb4KIPFinder : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KIPFinder( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KIPFinder();
    /**
     * Aborts the network scan.
     */
    void abort();

  signals:
    /**
     * Emits an Smb4KHostItem carrying the IP address.
     */
    void ip_address( Smb4KHostItem *item );
    /**
     * Emits the running signal.
     */
    void running( int mode, bool on );

  protected slots:
    /**
     * Get the IP addresses of the hosts in the list.
     */
    void getIPAddress();
    /**
     * Is called, if something is received via stdout.
     */
    void slotReceivedStdout( KProcess *, char *buf, int len );
    /**
     * Is called, when the KProcess exited.
     */
    void slotProcessExited( KProcess * );
    /**
     * Takes the incoming data and puts it to the queue.
     */
    void slotInput( const QValueList<Smb4KHostItem *> &list );

  private:
    /**
     * The KProcess object.
     */
    KProcess *m_proc;
    /**
     * The timer object.
     */
    QTimer *m_timer;
    /**
     * The current workgroup.
     */
    QString m_workgroup;
    /**
     * This bool is TRUE if the IP finder is working, else it is FALSE.
     */
    bool m_working;
    /**
     * This list holds all hosts that need to get an IP address.
     */
    QPtrQueue<Smb4KHostItem> m_queue;
};

#endif
