/***************************************************************************
                          smb4kprint  -  description
                             -------------------
    begin                : Tue Mar 30 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KPRINT_H
#define SMB4KPRINT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qstring.h>
#include <qwidget.h>

// KDE includes
#include <kprocess.h>
#include <kconfig.h>
#include <kfileitem.h>

// application specific includes
#include "smb4kprintinfo.h"
#include "smb4kpasswordhandler.h"


/**
 * This is a core class. It provides the interface for printing documents over
 * the network neighborhood.
 *
 * You shouldn't use this class directly but access it through Smb4KCore.
 */

class Smb4KPrint : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KPrint( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KPrint();
    /**
     * This function initializes the printer stuff. It returns TRUE
     * in case of success.
     */
    bool init( Smb4KPrintInfo *info );
    /**
     * Aborts the print process.
     */
    void abort();

  signals:
    /**
     * This signal is emitted, when the printing process started
     * or entered a different stage.
     *
     * @param mode          the run mode (see smb4kdefs.h)
     *
     * @param on            TRUE if the print handler is running and FALSE otherwise
     */
    void running( int mode, bool on );
    /**
     * This signal is emitted, if something went wrong.
     *
     * @param error_code    the error code (see smb4kdefs.h)
     *
     * @param error_message the error message
     */
    void error( int error_code, const QString &error_message );

  protected:
    /**
     * Starts any process.
     */
    void startProcess( int state );
    /**
     * Ends any process.
     */
    void endProcess();

  protected slots:
    /**
     * This slot receives output at stdout.
     */
    void slotReceivedStdout( KProcess *, char *buf, int len );
    /**
     * This slot receives output at stderr.
     */
    void slotReceivedStderr( KProcess *, char *buf, int len );
    /**
     * This slot is called when the process exited.
     */
    void slotProcessExited( KProcess * );
    /**
     * Is called, when the printing should be retried.
     */
    void slotRetry();

  private:
    /**
     * The print info object.
     */
    Smb4KPrintInfo *m_info;
    /**
     * The KProcess object.
     */
    KProcess *m_proc;
    /**
     * The buffer.
     */
    QString m_buffer;
    /**
     * Starts the printing of text files.
     */
    void startPrinting();
    /**
     * Ends the print process.
     */
    void endPrintProcess();
    /**
     * Enumeration for processing the data.
     */
    enum State{ Idle, Print, Convert };
    /**
     * Holds the state.
     */
    int m_state;
    /**
     * Ends the conversion process.
     */
    void endConversionProcess();
    /**
     * Converts DVI files to PostScript using dvips.
     */
    void convertDVIToPS();
    /**
     * Converts text file to PostScript usinf enscript.
     */
    void convertTextToPS();
    /**
     * The KFileItem object.
     */
    KFileItem *m_item;
    /**
     * The password handler of this class.
     */
    Smb4KPasswordHandler *m_password_handler;
};

#endif
