/***************************************************************************
                          smb4kshare  -  description
                             -------------------
    begin                : Do Mr 4 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSHARE_H
#define SMB4KSHARE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

// application specific includes
#include "smb4kuser.h"

/** 
 * This class encapsulate the representation of a mounted share object. 
 */

class Smb4KShare
{
  public:
    /**
     * The default constructor.
     *
     * @param name        The name of the share: //HOST/SHARE or //USER@HOST/SHARE (FreeBSD).
     *
     * @param path        The path where the share is mounted to.
     *
     * @param filesystem  The filesystem that was used. In this case it should be "smbfs".
     * 
     * @param uid         The UID of the user.
     *
     * @param gid         The GID of the user.
     * 
     * @param broken      Determines whether the share is broken. "Broken" means that the share is unaccessible.
     */
    Smb4KShare( const QString &name, const QString &path, const QString &filesystem, const int uid = 0, const int gid = 0, bool broken = false );
    /**
     * The constructor for CIFS shares. It does not take the UID and GID, but the
     * user name with which the login was done.
     *
     * @param name        The name of the share: //HOST/SHARE or //USER@HOST/SHARE (FreeBSD).
     *
     * @param path        The path where the share is mounted to.
     *
     * @param filesystem  The filesystem that was used. In this case it should be "cifs".
     *
     * @param username    The the user name that had to be used for authentication. It can be different from the local user name.
     *
     * @param foreign     Determines whether the share was mounted by another user (i.e. is a foreign share).
     *
     * @param broken      Determines whether the share is broken. "Broken" means that the share is unaccessible.
     */
    Smb4KShare( const QString &name, const QString &path, const QString &filesystem, const QString &username, bool foreign, bool broken = false );
    /**
     * Empty constructor.
     */
    Smb4KShare() {}
    /**
     * Copy constructor.
     *
     * @param share       The share that is to be copied.
     */
    Smb4KShare( const Smb4KShare &share );
    /**
     * The destructor
     */
    ~Smb4KShare();
    /**
     * Returns the name of the share. All spaces are replaced
     * by underscores.
     */
    QString getName() const;
    /**
     * Returns the path (mount point) of the share.
     */
    QString getPath() const;
    /**
     * Returns the canonical path of the share.
     */
    QString getCanonicalPath() const;
    /**
     * Returns the UID of the mounted share.
     */
    int getUID() const;
    /**
     * Returns the GID of the mounted share.
     */
    int getGID() const;
    /**
     * Returns the name of the user of the share.
     */
    QString getUser() const;
    /**
     * Returns the name of the group of the share.
     */
    QString getGroup() const;
    /**
     * Returns the file system of the share.
     */
    QString getFilesystem() const;
    /**
     * Returns the CIFS login (user name).
     */
    QString getCIFSLogin() const;
    /**
     * Is TRUE if the share is/seems to be mounted by another
     * user.
     */
    bool isForeign() const;
    /**
     * Returns TRUE if the share is broken and FALSE otherwise.
     */
    bool isBroken() const;
    /**
     * Sets the share to be broken.
     *
     * @param broken      TRUE if the share is broken and FALSE otherwise.
     */
    void setBroken( bool broken );

  private:
    QString m_name;
    QString m_path;
    QString m_filesystem;
    Smb4KUser m_userinfo;
    QString m_cifs_login;
    bool m_foreign_mount;
    bool m_broken;
};

#endif
